window.App = window.App || {};
window.App.Home = (function ($) {
    'use strict';

    $(document).ready(function () {
        var $window = $(window),
            $home = $('#home'),
            $calculator = $home.find('.calculator'),
            $messagePopup = $('#message-popup');

        if (!$home.length) {
            return;
        }

        function setHomeCalculatorBgWidth() {
            var $calculatorBg = $calculator.find('.cbg');
            var calculatorBgWidth = $window.width() - $calculatorBg.offset().left;
            $calculatorBg.css('width', calculatorBgWidth);

            var $sliderBg = $home.find('.slider-background');
            var sliderBgWidth = $sliderBg.offset().left;
            $sliderBg.css('width', $sliderBg.width() + sliderBgWidth + 1);
        }

        setHomeCalculatorBgWidth();

        function handlePartnersSlider() {
            var $partners = $home.find('.partners'),
                $ul = $partners.find('ul'),
                $prevArrow = $partners.find('.prev-arrow'),
                $nextArrow = $partners.find('.next-arrow'),
                hideArrows = $ul.find('li').length <= 4;

            $ul.slick({
                prevArrow: $prevArrow,
                nextArrow: $nextArrow,
                pauseOnHover: false,
                swipe: false,
                infinite: true,
                slidesToShow: 4,
                slidesToScroll: 1,
                responsive: [
                    {
                        breakpoint: 1140,
                        settings: {
                            swipe: true,
                            swipeToSlide: true
                        }
                    },
                    {
                        breakpoint: 700,
                        settings: {
                            swipe: true,
                            swipeToSlide: true,
                            slidesToShow: 3
                        }
                    },
                    {
                        breakpoint: 450,
                        settings: {
                            swipe: true,
                            swipeToSlide: true,
                            slidesToShow: 1
                        }
                    }
                ]
            });

            if (hideArrows) {
                $prevArrow.hide();
                $nextArrow.hide();
            }
        }

        handlePartnersSlider();

        function handleMobileBoxes() {
            var $boxes = $home.find('.box');
            $boxes.find('h3, h2, h1').off('click');

            if ($window.width() >= 768) {
                return;
            }

            $boxes.find('h3, h2, h1').click(function () {
                var $text = $(this).parent().find('> .text');
                $text.slideToggle(200);
                $(this).closest('.box').toggleClass('open');

                $boxes.not($(this).parent()).find('> .text').slideUp(200);
            });
        }

        handleMobileBoxes();

        function handleYoutubeVideo() {
            $(document).ready(function() {
                $home.find('.video .play').magnificPopup({
                    disableOn: 768,
                    type: 'iframe',
                    removalDelay: 160,
                    preloader: false
                });
            });
        }
        handleYoutubeVideo();

        function handleCalculatorSuccessMessage() {
            if(typeof showCalculatorSuccessMessage !== 'undefined') {
                var $inner = $messagePopup.find('.inner');
                $messagePopup.fadeIn(300);

                $inner.css({
                    'margin-top': $inner.outerHeight() / -2
                });

                $(document).click(function () {
                    $messagePopup.fadeOut(300);
                });
            }
        }
        handleCalculatorSuccessMessage();

        function handleHomeTopForTablet() {
            var $leftSide = $home.find('.left-side'),
                $calculator = $home.find('.calculator');

            if($(window).width() <= 1140 && $(window).width() >= 850) {
                $leftSide.css('width', 450 + ($window.width() - $calculator.width() - 450) / 2);
            } else {
                $leftSide.css('width', '');
            }

            setHomeCalculatorBgWidth();
        }

        handleHomeTopForTablet();

        $window.resize(function () {
            handleHomeTopForTablet();
            handleMobileBoxes();
            setHomeCalculatorBgWidth();
        });
    });

}(jQuery));