<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://cabrerahector.com
 * @since      4.0.0
 *
 * @package    WordPressPopularPosts
 * @subpackage WordPressPopularPosts/includes
 */
/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      4.0.0
 * @package    WordPressPopularPosts
 * @subpackage WordPressPopularPosts/includes
 * @author     Hector Cabrera <me@cabrerahector.com>
 */

class WPP_i18n {

    /**
     * Load the plugin text domain for translation.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain() {

        $locale = apply_filters( 'plugin_locale', get_locale(), 'wordpress-popular-posts' );
        load_textdomain( 'wordpress-popular-posts', WP_LANG_DIR . '/' . 'wordpress-popular-posts' . '/' . 'wordpress-popular-posts' . '-' . $locale . '.mo' );
        load_plugin_textdomain( 'wordpress-popular-posts', false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/' );

    }

} // End WPP_i18n class
