<?php

namespace AppBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class OrderTransportValidator extends ConstraintValidator
{
    /**
     * @param mixed $protocol
     * @param Constraint $constraint
     */
    public function validate($protocol, Constraint $constraint)
    {
        if($protocol->getTransport()) {
            $success = true;

            if(!$protocol->getCity()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('city')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getPostalCode()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('postalCode')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getFirstDimension()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('firstDimension')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getSecondDimension()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('secondDimension')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getThirdDimension()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('thirdDimension')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getQuantity()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('quantity')
                    ->addViolation();
                $success = false;
            }

            if(!$protocol->getQuantityType()) {
                $this->context->buildViolation($constraint->fieldMessage)
                    ->atPath('quantityType')
                    ->addViolation();
                $success = false;
            }

            if(!$success) {
                $this->context->buildViolation($constraint->message)
                    ->atPath('transport')
                    ->addViolation();
            }
        }
    }
}