<?php

namespace AppBundle\Service;

use Doctrine\ORM\EntityManager;

class ExchangeRateService
{
    /**
     * @var EntityManager
     */
    private $entityManager;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @return bool|mixed
     */
    static public function get($param = null)
    {
        try {
            $xmlNames = file('http://www.nbp.pl/kursy/xml/dir.txt');
        } catch(\Exception $e) {
            return false;
        }

        foreach (array_reverse($xmlNames) as $xmlName) {
            if (strpos($xmlName, 'a') !== false) {
                break;
            }
        }

        if(!isset($xmlName)) {
            return false;
        }
        $w = null;
        if($param == 'e'){
          $w = 'EUR';
        }
        else{
          $w = 'USD';
        }
        $exchangeRatesXml = simplexml_load_file('http://www.nbp.pl/kursy/xml/' . trim($xmlName) . '.xml');
        foreach ($exchangeRatesXml->pozycja as $object) {
            if ($object->kod_waluty == $w) {
                $exchangeRate = str_replace(',', '.', $object->kurs_sredni);
                break;
            }
        }

        return isset($exchangeRate) ? $exchangeRate : false;
    }

    /**
     * @return bool|mixed
     */
    public function getAndUpdate($param = null)
    {
        $lastExchangeRateSetting = null;

        if($param == 'e'){
          $lastExchangeRateSetting = $this->entityManager
              ->getRepository('AppBundle:SettingEuro')->findOneBySlug('euro');
        }
        else{
          $lastExchangeRateSetting = $this->entityManager
              ->getRepository('AppBundle:Setting')->findOneBySlug('usd');
        }


        $now = new \DateTime();
        if ($lastExchangeRateSetting->getUpdatedAt()->format('Y-m-d') == $now->format('Y-m-d')) {
            return $lastExchangeRateSetting->getValue();
        }

        $exchangeRate = self::get($param);

        if (!$exchangeRate) {
            return $lastExchangeRateSetting->getValue();
        }

        $lastExchangeRateSetting->setValue($exchangeRate);
        $this->entityManager->flush($lastExchangeRateSetting);

        return $exchangeRate;
    }
}
