<?php

namespace AppBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class VoucherType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'name',
                null,
                array(
                    'label' => 'Nazwa'
                )
            )
            ->add(
                'code',
                null,
                array(
                    'label' => 'Kod'
                )
            )
            ->add(
                'value',
                'number',
                array(
                    'label' => 'Wartość',
                    'precision' => 2
                )
            )
            ->add(
                'isActive',
                null,
                array(
                    'label' => 'Jest aktywny',
                    'required' => false,
                    'data' => true
                )
            );
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Voucher',
                )
            );
    }

    public function getName()
    {
        return 'voucher';
    }
}