<?php

namespace AppBundle\Form\Type;

use AppBundle\Form\DataTransformer\PortToIdTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\NotNull;

class ApplicationType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'loading',
                'entity',
                array(
                    'label' => 'Port załadunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectFormWithLoadings('Polska'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'unloading',
                'entity',
                array(
                    'label' => 'Port rozładunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectFormWithUnloadings('Polska'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'volume',
                'number',
                array(
                    'label' => 'Objętość (m3)',
                    'precision' => 3,
                    'data' => 1
                )
            )
            ->add(
                'weight',
                'number',
                array(
                    'label' => 'Waga',
                    'data' => 1000
                )
            )
            ->add(
                'documentary',
                'checkbox',
                array(
                    'label' => 'Opłata dokumentacyjna',
                    'required' => false
                )
            )
            ->add(
                'warehouse',
                'checkbox',
                array(
                    'label' => 'Koszty magazynowe',
                    'required' => false
                )
            )
            ->add(
                'thc',
                'checkbox',
                array(
                    'label' => 'Koszty terminalowe THC',
                    'required' => false
                )
            )
            ->add(
                'isps',
                'checkbox',
                array(
                    'label' => 'Podjęcie z magazynu',
                    'required' => false
                )
            )
            ->add(
                'customs',
                'checkbox',
                array(
                    'label' => 'Odprawa celna',
                    'required' => false
                )
            )
            ->add(
                'transport',
                'checkbox',
                array(
                    'label' => 'Transport drogowy',
                    'required' => false
                )
            )
            ->add(
                'city',
                'text',
                array(
                    'label' => 'Miasto',
                    'required' => false
                )
            )
            ->add(
                'postalCode',
                'text',
                array(
                    'label' => 'Kod pocztowy',
                    'required' => false
                )
            )
            ->add(
                'firstDimension',
                'number',
                array(
                    'label' => false,
                    'attr' => array(
                        'placeholder' => 'dł'
                    ),
                    'required' => false
                )
            )
            ->add(
                'secondDimension',
                'number',
                array(
                    'label' => false,
                    'attr' => array(
                        'placeholder' => 'szer'
                    ),
                    'required' => false
                )
            )
            ->add(
                'thirdDimension',
                'number',
                array(
                    'label' => false,
                    'attr' => array(
                        'placeholder' => 'wys'
                    ),
                    'required' => false
                )
            )
            ->add(
                'quantity',
                'number',
                array(
                    'label' => 'Ilość sztuk',
                    'precision' => 0,
                    'required' => false
                )
            )
            ->add(
                'quantityType',
                'choice',
                array(
                    'label' => 'Typ',
                    'choices' => array(
                        'pallets' => 'palety',
                        'packages' => 'kartony/paczki',
                        'unknown' => 'nie wiem'
                    ),
                    'placeholder' => false,
                    'required' => false
                )
            )
            ->add(
                'voucher',
                'text',
                array(
                    'label' => 'Kupon rabatowy',
                    'mapped' => false,
                    'required' => false
                )
            )
            ->add(
                'fullName',
                'text',
                array(
                    'label' => 'Imię i nazwisko',
                    'required' => false
                )
            )
            ->add(
                'company',
                'text',
                array(
                    'label' => 'Nazwa firmy',
                    'required' => false
                )
            )
            ->add(
                'phone',
                'text',
                array(
                    'label' => 'Telefon',
                    'required' => false
                )
            )
            ->add(
                'email',
                'text',
                array(
                    'label' => 'Email',
                    'required' => false
                )
            )
            ->add(
                'comment',
                'textarea',
                array(
                    'label' => 'Komentarz',
                    'required' => false
                )
            );

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Application'
                )
            )
            ->setRequired(array('em'))
            ->setAllowedTypes('em', 'Doctrine\Common\Persistence\ObjectManager');
    }

    public function getName()
    {
        return 'application';
    }
}