<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\User;
use Doctrine\ORM\EntityRepository;

class UserRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('u')
            ->where('u.isRemoved != true')
            ->orWhere('u.isRemoved IS NULL')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getRemovedListQuery()
    {
        return $this
            ->createQueryBuilder('u')
            ->where('u.isRemoved = true')
            ->getQuery();
    }

    /**
     * @return User[]
     */
    public function findNotRemoved()
    {
        return $this->getListQuery()->getResult();
    }
}
