<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\Consultant;
use Doctrine\ORM\EntityRepository;

class ConsultantRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('c')
            ->where('c.isRemoved != true')
            ->orWhere('c.isRemoved IS NULL')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getRemovedListQuery()
    {
        return $this
            ->createQueryBuilder('c')
            ->where('c.isRemoved = true')
            ->getQuery();
    }

    /**
     * @return Consultant[]
     */
    public function findNotRemoved()
    {
        return $this->getListQuery()->getResult();
    }
}
