<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\Consultant;
use Doctrine\ORM\EntityRepository;

class ConsultantHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('ch')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(Consultant $consultant)
    {
        return $this
            ->createQueryBuilder('ch')
            ->where('ch.consultant = :consultant')
            ->setParameter('consultant', $consultant)
            ->getQuery();
    }
}
