<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;
use AppBundle\Entity\Connection;

class ConnectionHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('ch')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(Connection $connection)
    {
        return $this
            ->createQueryBuilder('ch')
            ->where('ch.connection = :connection')
            ->setParameter('connection', $connection)
            ->getQuery();
    }
}
