<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Connection
 */
class Connection
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var float
     */
    private $cost;

    /**
     * @var \DateTime
     */
    private $validTo;

    /**
     * @var boolean
     */
    private $isRemoved;

    /**
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $loading;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $unloading;


    private $useeuro;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cost
     *
     * @param float $cost
     * @return Connection
     */
    public function setCost($cost)
    {
        $this->cost = $cost;

        return $this;
    }

    /**
     * Get cost
     *
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * Set validTo
     *
     * @param \DateTime $validTo
     * @return Connection
     */
    public function setValidTo($validTo)
    {
        $this->validTo = $validTo;

        return $this;
    }

    /**
     * Get validTo
     *
     * @return \DateTime
     */
    public function getValidTo()
    {
        return $this->validTo;
    }

    /**
     * Set isRemoved
     *
     * @param boolean $isRemoved
     * @return Connection
     */
    public function setIsRemoved($isRemoved)
    {
        $this->isRemoved = $isRemoved;

        return $this;
    }

    /**
     * Get isRemoved
     *
     * @return boolean
     */
    public function getIsRemoved()
    {
        return $this->isRemoved;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     * @return Connection
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return Connection
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set loading
     *
     * @param \AppBundle\Entity\Port $loading
     * @return Connection
     */
    public function setLoading(\AppBundle\Entity\Port $loading = null)
    {
        $this->loading = $loading;

        return $this;
    }

    /**
     * Get loading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getLoading()
    {
        return $this->loading;
    }

    /**
     * Set unloading
     *
     * @param \AppBundle\Entity\Port $unloading
     * @return Connection
     */
    public function setUnloading(\AppBundle\Entity\Port $unloading = null)
    {
        $this->unloading = $unloading;

        return $this;
    }

    /**
     * Get unloading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getUnloading()
    {
        return $this->unloading;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtAsNow()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreFlush
     */
    public function setUpdatedAtAsNow()
    {
        $this->updatedAt = new \DateTime();
    }


    public function getUseeuro(){
      return $this->useeuro;
    }

    public function setUseeuro($useeuro){
      $this->useeuro = $useeuro;
      return $this;
    }
}
