<?php

namespace AppBundle\DataFixtures\Orm;

use AppBundle\Entity\SettingHistory;
use AppBundle\Service\ExchangeRateService;
use Doctrine\Common\DataFixtures\FixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use AppBundle\Entity\Setting;

class LoadSettingData implements FixtureInterface
{
    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $settingsData = array(
            array('Oplata dokumentacyjna', 'documentary', '20'),
            array('THC', 'thc', '20'),
            array('ISPS', 'isps', '20'),
            array('Odprawa celna', 'customs', '60'),
            array('Koszty magazynowe', 'warehouse', '20'),
            array('Ostatni kurs USD', 'usd', ExchangeRateService::get(), true)
        );

        foreach($settingsData as $settingData) {
            $setting = new Setting();
            $setting
                ->setName($settingData[0])
                ->setSlug($settingData[1])
                ->setValue($settingData[2]);

            if(isset($settingData[3])) {
                $setting->setIsRemoved(true);
            }

            $manager->persist($setting);

            $settingHistory = new SettingHistory();
            $settingHistory
                ->setValue($settingData[2])
                ->setSetting($setting);

            $manager->persist($settingHistory);
        }
        $manager->flush();
    }
}