/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.vehicle;

import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.trailer.StorageTrailerEntity;
import com.mrcrayfish.vehicle.init.ModSounds;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LawnMowerEntity
extends LandVehicleEntity {
    public LawnMowerEntity(EntityType<? extends LawnMowerEntity> type, World worldIn) {
        super(type, worldIn);
        this.setMaxSpeed(8.0f);
        this.setFuelCapacity(5000.0f);
    }

    @Override
    public void updateVehicle() {
        super.updateVehicle();
        if (!this.field_70170_p.field_72995_K && this.func_184179_bs() != null) {
            AxisAlignedBB axisAligned = this.func_174813_aQ().func_186662_g(0.25);
            Vec3d lookVec = this.func_70040_Z().func_186678_a(0.5);
            int minX = MathHelper.func_76128_c((double)(axisAligned.field_72340_a + lookVec.field_72450_a));
            int maxX = MathHelper.func_76143_f((double)(axisAligned.field_72336_d + lookVec.field_72450_a));
            int minZ = MathHelper.func_76128_c((double)(axisAligned.field_72339_c + lookVec.field_72449_c));
            int maxZ = MathHelper.func_76143_f((double)(axisAligned.field_72334_f + lookVec.field_72449_c));
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    BlockPos pos = new BlockPos((double)x, axisAligned.field_72338_b + 0.5, (double)z);
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    StorageTrailerEntity trailer = null;
                    if (this.getTrailer() instanceof StorageTrailerEntity) {
                        trailer = (StorageTrailerEntity)this.getTrailer();
                    }
                    if (!(state.func_177230_c() instanceof BushBlock)) continue;
                    List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.field_70170_p), (BlockPos)pos, null);
                    for (ItemStack stack : drops) {
                        this.addItemToStorage(trailer, stack);
                    }
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.field_70170_p.func_184133_a(null, pos, state.func_177230_c().getSoundType(state, (IWorldReader)this.field_70170_p, pos, (Entity)this).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                }
            }
        }
    }

    private void addItemToStorage(StorageTrailerEntity storageTrailer, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (storageTrailer != null && storageTrailer.getInventory() != null) {
            StorageInventory storage = storageTrailer.getInventory();
            stack = storage.func_174894_a(stack);
            if (!stack.func_190926_b()) {
                if (storageTrailer.getTrailer() instanceof StorageTrailerEntity) {
                    this.addItemToStorage((StorageTrailerEntity)storageTrailer.getTrailer(), stack);
                } else {
                    this.spawnItemStack(this.field_70170_p, stack);
                }
            }
        } else {
            this.spawnItemStack(this.field_70170_p, stack);
        }
    }

    private void spawnItemStack(World worldIn, ItemStack stack) {
        while (!stack.func_190926_b()) {
            ItemEntity itemEntity = new ItemEntity(worldIn, this.field_70169_q, this.field_70167_r, this.field_70166_s, stack.func_77979_a(this.field_70146_Z.nextInt(21) + 10));
            itemEntity.func_174867_a(20);
            itemEntity.func_213293_j(-this.func_213322_ci().field_72450_a / 4.0, this.field_70146_Z.nextGaussian() * 0.05 + 0.2, -this.func_213322_ci().field_72449_c / 4.0);
            worldIn.func_217376_c((Entity)itemEntity);
        }
    }

    @Override
    public SoundEvent getMovingSound() {
        return (SoundEvent)ModSounds.ATV_ENGINE_MONO.get();
    }

    @Override
    public SoundEvent getRidingSound() {
        return (SoundEvent)ModSounds.ATV_ENGINE_STEREO.get();
    }

    @Override
    public EngineType getEngineType() {
        return EngineType.SMALL_MOTOR;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    public boolean canTowTrailer() {
        return true;
    }

    @Override
    public boolean isLockable() {
        return false;
    }
}

