/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.ItemLookup;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.entity.vehicle.BumperCarEntity;
import com.mrcrayfish.vehicle.init.ModDataKeys;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.inventory.container.EditVehicleContainer;
import com.mrcrayfish.vehicle.item.EngineItem;
import com.mrcrayfish.vehicle.item.JerryCanItem;
import com.mrcrayfish.vehicle.item.WheelItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAccelerating;
import com.mrcrayfish.vehicle.network.message.MessageHorn;
import com.mrcrayfish.vehicle.network.message.MessagePower;
import com.mrcrayfish.vehicle.network.message.MessageTurnAngle;
import com.mrcrayfish.vehicle.network.message.MessageTurnDirection;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.util.CommonUtils;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class PoweredVehicleEntity
extends VehicleEntity
implements IInventoryChangedListener,
INamedContainerProvider {
    protected static final DataParameter<Float> CURRENT_SPEED = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ACCELERATION_SPEED = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> POWER = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> TURN_DIRECTION = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> TARGET_TURN_ANGLE = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> TURN_SENSITIVITY = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> MAX_TURN_ANGLE = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ACCELERATION_DIRECTION = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HAS_ENGINE = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> ENGINE_TIER = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HORN = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> REQUIRES_FUEL = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> CURRENT_FUEL = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> FUEL_CAPACITY = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> NEEDS_KEY = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<ItemStack> KEY_STACK = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Boolean> HAS_WHEELS = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> WHEEL_TYPE = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> WHEEL_COLOR = EntityDataManager.func_187226_a(PoweredVehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevCurrentSpeed;
    public float currentSpeed;
    public float speedMultiplier;
    public boolean boosting;
    public int boostTimer;
    public boolean launching;
    public int launchingTimer;
    public boolean disableFallDamage;
    public float fuelConsumption = 0.25f;
    protected boolean charging;
    protected AccelerationDirection prevAcceleration;
    protected double[] wheelPositions;
    protected boolean wheelsOnGround = true;
    public float turnAngle;
    public float prevTurnAngle;
    public float deltaYaw;
    public float wheelAngle;
    public float prevWheelAngle;
    @OnlyIn(value=Dist.CLIENT)
    public float targetWheelAngle;
    @OnlyIn(value=Dist.CLIENT)
    public float renderWheelAngle;
    @OnlyIn(value=Dist.CLIENT)
    public float prevRenderWheelAngle;
    @OnlyIn(value=Dist.CLIENT)
    public int wheelieCount;
    @OnlyIn(value=Dist.CLIENT)
    public int prevWheelieCount;
    public float vehicleMotionX;
    public float vehicleMotionY;
    public float vehicleMotionZ;
    private UUID owner;
    private Inventory vehicleInventory;
    private FuelPortType fuelPortType;
    private boolean fueling;

    protected PoweredVehicleEntity(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.field_70138_W = 1.0f;
    }

    public PoweredVehicleEntity(EntityType<?> entityType, World worldIn, double posX, double posY, double posZ) {
        this(entityType, worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(10.0f));
        this.field_70180_af.func_187214_a(ACCELERATION_SPEED, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(POWER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TURN_DIRECTION, (Object)TurnDirection.FORWARD.ordinal());
        this.field_70180_af.func_187214_a(TARGET_TURN_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TURN_SENSITIVITY, (Object)6);
        this.field_70180_af.func_187214_a(MAX_TURN_ANGLE, (Object)45);
        this.field_70180_af.func_187214_a(ACCELERATION_DIRECTION, (Object)AccelerationDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(HAS_ENGINE, (Object)false);
        this.field_70180_af.func_187214_a(ENGINE_TIER, (Object)0);
        this.field_70180_af.func_187214_a(HORN, (Object)false);
        this.field_70180_af.func_187214_a(REQUIRES_FUEL, Config.SERVER.fuelEnabled.get());
        this.field_70180_af.func_187214_a(CURRENT_FUEL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FUEL_CAPACITY, (Object)Float.valueOf(15000.0f));
        this.field_70180_af.func_187214_a(NEEDS_KEY, (Object)false);
        this.field_70180_af.func_187214_a(KEY_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(HAS_WHEELS, (Object)true);
        this.field_70180_af.func_187214_a(WHEEL_TYPE, (Object)WheelType.STANDARD.ordinal());
        this.field_70180_af.func_187214_a(WHEEL_COLOR, (Object)-1);
        List<Wheel> wheels = this.getProperties().getWheels();
        if (wheels != null && wheels.size() > 0) {
            this.wheelPositions = new double[wheels.size() * 3];
        }
    }

    public abstract SoundEvent getMovingSound();

    public abstract SoundEvent getRidingSound();

    public SoundEvent getHornSound() {
        return (SoundEvent)ModSounds.HORN_MONO.get();
    }

    public SoundEvent getHornRidingSound() {
        return (SoundEvent)ModSounds.HORN_STEREO.get();
    }

    public void playFuelPortOpenSound() {
        if (!this.fueling) {
            this.fuelPortType.playOpenSound();
            this.fueling = true;
        }
    }

    public void playFuelPortCloseSound() {
        if (this.fueling) {
            this.fuelPortType.playCloseSound();
            this.fueling = false;
        }
    }

    public float getMinEnginePitch() {
        return 0.5f;
    }

    public float getMaxEnginePitch() {
        return 1.2f;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void onClientInit() {
        super.onClientInit();
        this.setFuelPortType(FuelPortType.DEFAULT);
    }

    protected void setFuelPortType(FuelPortType fuelPortType) {
        this.fuelPortType = fuelPortType;
    }

    public void fuelVehicle(PlayerEntity player, Hand hand) {
        if (((Optional)SyncedPlayerData.instance().get(player, ModDataKeys.GAS_PUMP)).isPresent()) {
            GasPumpTankTileEntity gasPumpTank;
            FluidStack stack;
            BlockPos pos = (BlockPos)((Optional)SyncedPlayerData.instance().get(player, ModDataKeys.GAS_PUMP)).get();
            TileEntity tileEntity = this.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof GasPumpTileEntity && (tileEntity = this.field_70170_p.func_175625_s(pos.func_177977_b())) instanceof GasPumpTankTileEntity && !(stack = (gasPumpTank = (GasPumpTankTileEntity)tileEntity).getFluidTank().drain(200, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                stack.setAmount(this.addFuel(stack.getAmount()));
                if (stack.getAmount() > 0) {
                    gasPumpTank.getFluidTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            return;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof JerryCanItem) {
            JerryCanItem jerryCan = (JerryCanItem)stack.func_77973_b();
            int rate = jerryCan.getFillRate(stack);
            int drained = jerryCan.drain(stack, rate);
            int remaining = this.addFuel(drained);
            jerryCan.fill(stack, remaining);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_70170_p.field_72995_K) return super.func_184230_a(player, hand);
        if (this.owner == null) {
            this.owner = player.func_110124_au();
        }
        if (stack.func_77973_b() == ModItems.KEY.get()) {
            if (!this.owner.equals(player.func_110124_au())) {
                CommonUtils.sendInfoMessage(player, "vehicle.status.invalid_owner");
                return false;
            }
            if (this.isLockable()) {
                CompoundNBT tag = CommonUtils.getOrCreateStackTag(stack);
                if (tag.func_186855_b("VehicleId") && !this.func_110124_au().equals(tag.func_186857_a("VehicleId"))) return super.func_184230_a(player, hand);
                tag.func_186854_a("VehicleId", this.func_110124_au());
                if (!this.isKeyNeeded()) {
                    this.setKeyNeeded(true);
                    CommonUtils.sendInfoMessage(player, "vehicle.status.key_added");
                    return true;
                } else {
                    CommonUtils.sendInfoMessage(player, "vehicle.status.key_created");
                }
                return true;
            }
            CommonUtils.sendInfoMessage(player, "vehicle.status.not_lockable");
            return false;
        }
        if (stack.func_77973_b() != ModItems.WRENCH.get() || !(this.func_184187_bx() instanceof EntityJack)) return super.func_184230_a(player, hand);
        if (player.func_110124_au().equals(this.owner)) {
            this.openEditInventory(player);
            return true;
        } else {
            CommonUtils.sendInfoMessage(player, "vehicle.status.invalid_owner");
        }
        return true;
    }

    @Override
    public void onUpdateVehicle() {
        Entity controllingPassenger;
        this.prevCurrentSpeed = this.currentSpeed;
        this.prevTurnAngle = this.turnAngle;
        this.prevWheelAngle = this.wheelAngle;
        if (this.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        }
        if ((controllingPassenger = this.func_184179_bs()) != null) {
            this.createParticles();
        }
        if (this.charging && this.prevAcceleration == AccelerationDirection.CHARGING && this.getAcceleration() != this.prevAcceleration && this.getRealSpeed() > 0.95f) {
            this.releaseCharge();
        }
        this.updateGroundState();
        this.updateSpeed();
        this.updateTurning();
        this.updateVehicle();
        this.setSpeed(this.currentSpeed);
        VehicleProperties properties = this.getProperties();
        if (properties.getFrontAxelVec() == null || properties.getRearAxelVec() == null) {
            this.field_70177_z -= this.deltaYaw;
        }
        this.updateVehicleMotion();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        double deltaRot = this.field_70126_B - this.field_70177_z;
        if (deltaRot < -180.0) {
            this.field_70126_B += 360.0f;
        } else if (deltaRot >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.updateWheelPositions();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_72441_c((double)this.vehicleMotionX, (double)this.vehicleMotionY, (double)this.vehicleMotionZ));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 0.98, 0.8));
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
        }
        if (this.boostTimer > 0) {
            --this.boostTimer;
        } else {
            this.boosting = false;
            this.speedMultiplier = (float)((double)this.speedMultiplier * 0.85);
        }
        if (this.launchingTimer > 0) {
            this.disableFallDamage = true;
            --this.launchingTimer;
        } else {
            this.launching = false;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), entity -> entity instanceof BumperCarEntity);
        if (!list.isEmpty()) {
            for (Entity entity2 : list) {
                this.func_70108_f(entity2);
            }
        }
        if (this.requiresFuel() && controllingPassenger instanceof PlayerEntity && !((PlayerEntity)controllingPassenger).func_184812_l_() && this.isEnginePowered()) {
            float currentSpeed = Math.abs(Math.min(this.getSpeed(), this.getMaxSpeed()));
            float normalSpeed = Math.max(0.05f, currentSpeed / this.getMaxSpeed());
            float currentFuel = this.getCurrentFuel();
            if ((currentFuel = (float)((double)currentFuel - (double)(this.fuelConsumption * normalSpeed) * (Double)Config.SERVER.fuelConsumptionFactor.get())) < 0.0f) {
                currentFuel = 0.0f;
            }
            this.setCurrentFuel(currentFuel);
        }
        this.prevAcceleration = this.getAcceleration();
    }

    public void updateVehicle() {
    }

    public abstract void updateVehicleMotion();

    public abstract EngineType getEngineType();

    public FuelPortType getFuelPortType() {
        return FuelPortType.DEFAULT;
    }

    protected void updateSpeed() {
        float wheelModifier = this.getWheelModifier();
        this.currentSpeed = this.getSpeed();
        EngineTier engineTier = this.getEngineTier();
        AccelerationDirection acceleration = this.getAcceleration();
        if (acceleration != AccelerationDirection.CHARGING) {
            this.charging = false;
        }
        if (this.func_184179_bs() != null) {
            if (this.canDrive()) {
                boolean charging;
                boolean bl = charging = this.canCharge() && acceleration == AccelerationDirection.CHARGING && Math.abs(this.currentSpeed) < 0.5f;
                if (acceleration == AccelerationDirection.FORWARD || charging || this.charging) {
                    if (!this.charging) {
                        this.charging = charging;
                    }
                    if (this.wheelsOnGround || this.canAccelerateInAir()) {
                        float maxSpeed = this.getActualMaxSpeed() * wheelModifier * this.getPower();
                        if (this.currentSpeed < maxSpeed) {
                            this.currentSpeed += this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                            if (this.currentSpeed > maxSpeed) {
                                this.currentSpeed = maxSpeed;
                            }
                        }
                        if (this.currentSpeed > maxSpeed) {
                            this.currentSpeed *= 0.975f;
                        }
                        return;
                    }
                } else if (acceleration == AccelerationDirection.REVERSE && (this.wheelsOnGround || this.canAccelerateInAir())) {
                    float maxSpeed = -(4.0f + engineTier.getAdditionalMaxSpeed() / 2.0f) * wheelModifier * this.getPower();
                    if (this.currentSpeed > maxSpeed) {
                        this.currentSpeed -= this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                        if (this.currentSpeed < maxSpeed) {
                            this.currentSpeed = maxSpeed;
                        }
                    }
                    if (this.currentSpeed < maxSpeed) {
                        this.currentSpeed *= 0.975f;
                    }
                    return;
                }
            }
            this.currentSpeed = this.wheelsOnGround || this.canAccelerateInAir() ? (float)((double)this.currentSpeed * 0.9) : (float)((double)this.currentSpeed * 0.98);
        } else {
            this.currentSpeed = this.wheelsOnGround ? (float)((double)this.currentSpeed * 0.85) : (float)((double)this.currentSpeed * 0.98);
        }
    }

    protected void updateTurning() {
        this.turnAngle = this.getTargetTurnAngle();
        this.wheelAngle = this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(this.currentSpeed / 30.0f));
        this.deltaYaw = this.wheelAngle * (this.currentSpeed / 30.0f) / 2.0f;
        if (this.field_70170_p.field_72995_K) {
            this.renderWheelAngle = this.wheelAngle;
        }
    }

    public void createParticles() {
        VehicleProperties properties;
        if ((this.getAcceleration() == AccelerationDirection.FORWARD || this.charging) && (properties = this.getProperties()).getWheels() != null) {
            List<Wheel> wheels = properties.getWheels();
            for (int i = 0; i < wheels.size(); ++i) {
                int z;
                int y;
                Wheel wheel = wheels.get(i);
                if (!wheel.shouldSpawnParticles()) continue;
                double wheelX = this.wheelPositions[i * 3];
                double wheelY = this.wheelPositions[i * 3 + 1];
                double wheelZ = this.wheelPositions[i * 3 + 2];
                int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() + wheelX));
                BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.func_226278_cu_() + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() + wheelZ)));
                BlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_185904_a() == Material.field_151579_a || !state.func_185904_a().func_76229_l()) continue;
                Vec3d dirVec = this.func_174806_f(this.field_70125_A, this.getModifiedRotationYaw() + 180.0f).func_72441_c(0.0, 0.5, 0.0);
                if (this.charging) {
                    dirVec = dirVec.func_186678_a((double)(this.currentSpeed / 3.0f));
                }
                VehicleMod.PROXY.spawnWheelParticle(pos, state, this.func_226277_ct_() + wheelX, this.func_226278_cu_() + wheelY, this.func_226281_cx_() + wheelZ, dirVec);
            }
        }
        if (this.shouldShowEngineSmoke() && this.canDrive() && this.field_70173_aa % 2 == 0) {
            Vec3d smokePosition = this.getEngineSmokePosition().func_178785_b(-this.getModifiedRotationYaw() * ((float)Math.PI / 180));
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + smokePosition.field_72450_a, this.func_226278_cu_() + smokePosition.field_72448_b, this.func_226281_cx_() + smokePosition.field_72449_c, -this.func_213322_ci().field_72450_a, 0.0, -this.func_213322_ci().field_72449_c);
            if (this.charging && this.getRealSpeed() > 0.95f) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + smokePosition.field_72450_a, this.func_226278_cu_() + smokePosition.field_72448_b, this.func_226281_cx_() + smokePosition.field_72449_c, -this.func_213322_ci().field_72450_a, 0.0, -this.func_213322_ci().field_72449_c);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientUpdate() {
        this.prevRenderWheelAngle = this.renderWheelAngle;
        this.prevWheelieCount = this.wheelieCount;
        Entity entity = this.func_184179_bs();
        if (entity instanceof LivingEntity && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float power = VehicleMod.PROXY.getPower(this);
            if (power != this.getPower()) {
                this.setPower(power);
                PacketHandler.instance.sendToServer((Object)new MessagePower(power));
            }
            AccelerationDirection acceleration = VehicleMod.PROXY.getAccelerationDirection(livingEntity);
            if (this.getAcceleration() != acceleration) {
                this.setAcceleration(acceleration);
                PacketHandler.instance.sendToServer((Object)new MessageAccelerating(acceleration));
            }
            boolean horn = VehicleMod.PROXY.isHonking();
            this.setHorn(horn);
            PacketHandler.instance.sendToServer((Object)new MessageHorn(horn));
            TurnDirection direction = VehicleMod.PROXY.getTurnDirection(livingEntity);
            if (this.getTurnDirection() != direction) {
                this.setTurnDirection(direction);
                PacketHandler.instance.sendToServer((Object)new MessageTurnDirection(direction));
            }
            float targetTurnAngle = VehicleMod.PROXY.getTargetTurnAngle(this, false);
            this.setTargetTurnAngle(targetTurnAngle);
            PacketHandler.instance.sendToServer((Object)new MessageTurnAngle(targetTurnAngle));
        }
        if (this.isBoosting() && this.func_184179_bs() != null) {
            if (this.wheelieCount < 4) {
                ++this.wheelieCount;
            }
        } else if (this.wheelieCount > 0) {
            --this.wheelieCount;
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Owner", 10)) {
            this.owner = compound.func_186857_a("Owner");
        }
        if (compound.func_150297_b("HasEngine", 1)) {
            this.setEngine(compound.func_74767_n("HasEngine"));
        }
        if (compound.func_150297_b("EngineTier", 3)) {
            this.setEngineTier(EngineTier.getType(compound.func_74762_e("EngineTier")));
        }
        if (compound.func_150297_b("HasWheels", 1)) {
            this.setWheels(compound.func_74767_n("HasWheels"));
        }
        if (compound.func_150297_b("WheelType", 3)) {
            this.setWheelType(WheelType.getType(compound.func_74762_e("WheelType")));
        }
        if (compound.func_150297_b("WheelColor", 3)) {
            this.setWheelColor(compound.func_74762_e("WheelColor"));
        }
        if (compound.func_150297_b("MaxSpeed", 5)) {
            this.setMaxSpeed(compound.func_74760_g("MaxSpeed"));
        }
        if (compound.func_150297_b("AccelerationSpeed", 5)) {
            this.setAccelerationSpeed(compound.func_74760_g("AccelerationSpeed"));
        }
        if (compound.func_150297_b("TurnSensitivity", 3)) {
            this.setTurnSensitivity(compound.func_74762_e("TurnSensitivity"));
        }
        if (compound.func_150297_b("MaxTurnAngle", 3)) {
            this.setMaxTurnAngle(compound.func_74762_e("MaxTurnAngle"));
        }
        if (compound.func_150297_b("StepHeight", 5)) {
            this.field_70138_W = compound.func_74760_g("StepHeight");
        }
        if (compound.func_150297_b("RequiresFuel", 1)) {
            this.setRequiresFuel(compound.func_74767_n("RequiresFuel"));
        }
        if (compound.func_150297_b("CurrentFuel", 5)) {
            this.setCurrentFuel(compound.func_74760_g("CurrentFuel"));
        }
        if (compound.func_150297_b("FuelCapacity", 3)) {
            this.setFuelCapacity(compound.func_74762_e("FuelCapacity"));
        }
        if (compound.func_150297_b("KeyNeeded", 1)) {
            this.setKeyNeeded(compound.func_74767_n("KeyNeeded"));
        }
        this.setKeyStack(CommonUtils.readItemStackFromTag(compound, "KeyStack"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.owner != null) {
            compound.func_186854_a("Owner", this.owner);
        }
        compound.func_74757_a("HasEngine", this.hasEngine());
        compound.func_74768_a("EngineTier", this.getEngineTier().ordinal());
        compound.func_74757_a("HasWheels", this.hasWheels());
        compound.func_74768_a("WheelType", this.getWheelType().ordinal());
        compound.func_74768_a("WheelColor", this.getWheelColor());
        compound.func_74776_a("MaxSpeed", this.getMaxSpeed());
        compound.func_74776_a("AccelerationSpeed", this.getAccelerationSpeed());
        compound.func_74768_a("TurnSensitivity", this.getTurnSensitivity());
        compound.func_74768_a("MaxTurnAngle", this.getMaxTurnAngle());
        compound.func_74776_a("StepHeight", this.field_70138_W);
        compound.func_74757_a("RequiresFuel", this.requiresFuel());
        compound.func_74776_a("CurrentFuel", this.getCurrentFuel());
        compound.func_74776_a("FuelCapacity", this.getFuelCapacity());
        compound.func_74757_a("KeyNeeded", this.isKeyNeeded());
        CommonUtils.writeItemStackToTag(compound, "KeyStack", this.getKeyStack());
    }

    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        VehicleProperties properties = this.getProperties();
        for (Entity passenger : this.func_184188_bt()) {
            int seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au());
            if (seatIndex == -1 || !properties.getSeats().get(seatIndex).isDriverSeat()) continue;
            return passenger;
        }
        return null;
    }

    @Override
    public void updatePassengerPosition(Entity passenger) {
        int seatIndex;
        if (this.func_184196_w(passenger) && (seatIndex = this.getSeatTracker().getSeatIndex(passenger.func_110124_au())) != -1) {
            VehicleProperties properties = this.getProperties();
            if (seatIndex >= 0 && seatIndex < properties.getSeats().size()) {
                Seat seat = properties.getSeats().get(seatIndex);
                Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_216372_d(-1.0, 1.0, 1.0).func_186678_a(0.0625).func_178785_b(-(this.getModifiedRotationYaw() + 180.0f) * ((float)Math.PI / 180));
                passenger.func_70107_b(this.func_226277_ct_() - seatVec.field_72450_a, this.func_226278_cu_() + seatVec.field_72448_b + passenger.func_70033_W(), this.func_226281_cx_() - seatVec.field_72449_c);
                if (VehicleMod.PROXY.canApplyVehicleYaw(passenger)) {
                    passenger.field_70177_z -= this.deltaYaw;
                    passenger.func_70034_d(passenger.field_70177_z);
                }
                this.applyYawToEntity(passenger);
            }
        }
    }

    public boolean isMoving() {
        return this.currentSpeed != 0.0f;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public float getActualMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue() + this.getEngineTier().getAdditionalMaxSpeed();
    }

    public float getRealSpeed() {
        return this.currentSpeed / (this.getActualMaxSpeed() * this.getWheelModifier() * this.getPower());
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.currentSpeed;
    }

    public float getNormalSpeed() {
        return this.currentSpeed / this.getMaxSpeed();
    }

    public float getActualSpeed() {
        return (this.currentSpeed + this.currentSpeed * this.speedMultiplier) / this.getActualMaxSpeed();
    }

    public void setAccelerationSpeed(float speed) {
        this.field_70180_af.func_187227_b(ACCELERATION_SPEED, (Object)Float.valueOf(speed));
    }

    public float getAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    protected float getModifiedAccelerationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ACCELERATION_SPEED)).floatValue();
    }

    public double getKilometersPreHour() {
        return Math.sqrt(Math.pow(this.func_226277_ct_() - this.field_70169_q, 2.0) + Math.pow(this.func_226278_cu_() - this.field_70167_r, 2.0) + Math.pow(this.func_226281_cx_() - this.field_70166_s, 2.0)) * 20.0;
    }

    public void setTurnDirection(TurnDirection turnDirection) {
        this.field_70180_af.func_187227_b(TURN_DIRECTION, (Object)turnDirection.ordinal());
    }

    public TurnDirection getTurnDirection() {
        return TurnDirection.values()[(Integer)this.field_70180_af.func_187225_a(TURN_DIRECTION)];
    }

    public void setTargetTurnAngle(float targetTurnAngle) {
        this.field_70180_af.func_187227_b(TARGET_TURN_ANGLE, (Object)Float.valueOf(targetTurnAngle));
    }

    public float getTargetTurnAngle() {
        return ((Float)this.field_70180_af.func_187225_a(TARGET_TURN_ANGLE)).floatValue();
    }

    public void setAcceleration(AccelerationDirection direction) {
        this.field_70180_af.func_187227_b(ACCELERATION_DIRECTION, (Object)direction.ordinal());
    }

    public AccelerationDirection getAcceleration() {
        return AccelerationDirection.values()[(Integer)this.field_70180_af.func_187225_a(ACCELERATION_DIRECTION)];
    }

    public void setPower(float power) {
        this.field_70180_af.func_187227_b(POWER, (Object)Float.valueOf(MathHelper.func_76131_a((float)power, (float)0.0f, (float)1.0f)));
    }

    public float getPower() {
        return ((Float)this.field_70180_af.func_187225_a(POWER)).floatValue();
    }

    public void setTurnSensitivity(int sensitivity) {
        this.field_70180_af.func_187227_b(TURN_SENSITIVITY, (Object)sensitivity);
    }

    public int getTurnSensitivity() {
        return (Integer)this.field_70180_af.func_187225_a(TURN_SENSITIVITY);
    }

    public void setMaxTurnAngle(int turnAngle) {
        this.field_70180_af.func_187227_b(MAX_TURN_ANGLE, (Object)turnAngle);
    }

    public int getMaxTurnAngle() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_TURN_ANGLE);
    }

    public boolean hasEngine() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ENGINE);
    }

    public void setEngine(boolean hasEngine) {
        this.field_70180_af.func_187227_b(HAS_ENGINE, (Object)hasEngine);
    }

    public void setEngineTier(EngineTier engineTier) {
        this.field_70180_af.func_187227_b(ENGINE_TIER, (Object)engineTier.ordinal());
    }

    public EngineTier getEngineTier() {
        return EngineTier.getType((Integer)this.field_70180_af.func_187225_a(ENGINE_TIER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderEngine() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFuelPort() {
        return true;
    }

    public Vec3d getEngineSmokePosition() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public boolean shouldShowEngineSmoke() {
        return false;
    }

    public void setHorn(boolean activated) {
        this.field_70180_af.func_187227_b(HORN, (Object)activated);
    }

    public boolean getHorn() {
        return (Boolean)this.field_70180_af.func_187225_a(HORN);
    }

    public void setBoosting(boolean boosting) {
        this.boosting = boosting;
        this.boostTimer = 10;
    }

    public boolean isBoosting() {
        return this.boosting;
    }

    public void setLaunching(int hold) {
        this.launching = true;
        this.launchingTimer = hold;
        this.disableFallDamage = true;
    }

    public boolean isLaunching() {
        return this.launching;
    }

    public boolean requiresFuel() {
        return (Boolean)Config.SERVER.fuelEnabled.get() != false && (Boolean)this.field_70180_af.func_187225_a(REQUIRES_FUEL) != false;
    }

    public void setRequiresFuel(boolean requiresFuel) {
        this.field_70180_af.func_187227_b(REQUIRES_FUEL, (Object)((Boolean)Config.SERVER.fuelEnabled.get() != false && requiresFuel ? 1 : 0));
    }

    public boolean isFueled() {
        return !this.requiresFuel() || this.isControllingPassengerCreative() || this.getCurrentFuel() > 0.0f;
    }

    public void setCurrentFuel(float fuel) {
        this.field_70180_af.func_187227_b(CURRENT_FUEL, (Object)Float.valueOf(fuel));
    }

    public float getCurrentFuel() {
        return ((Float)this.field_70180_af.func_187225_a(CURRENT_FUEL)).floatValue();
    }

    public void setFuelCapacity(float capacity) {
        this.field_70180_af.func_187227_b(FUEL_CAPACITY, (Object)Float.valueOf(capacity));
    }

    public float getFuelCapacity() {
        return ((Float)this.field_70180_af.func_187225_a(FUEL_CAPACITY)).floatValue();
    }

    public void setFuelConsumption(float consumption) {
        this.fuelConsumption = consumption;
    }

    public float getFuelConsumption() {
        return this.fuelConsumption;
    }

    public int addFuel(int fuel) {
        if (!this.requiresFuel()) {
            return fuel;
        }
        float currentFuel = this.getCurrentFuel();
        int remaining = Math.max(0, Math.round((currentFuel += (float)fuel) - this.getFuelCapacity()));
        currentFuel = Math.min(currentFuel, this.getFuelCapacity());
        this.setCurrentFuel(currentFuel);
        return remaining;
    }

    public void setKeyNeeded(boolean needsKey) {
        this.field_70180_af.func_187227_b(NEEDS_KEY, (Object)needsKey);
    }

    public boolean isKeyNeeded() {
        return (Boolean)this.field_70180_af.func_187225_a(NEEDS_KEY);
    }

    public void setKeyStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(KEY_STACK, (Object)stack);
    }

    public ItemStack getKeyStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(KEY_STACK);
    }

    public void ejectKey() {
        if (!this.getKeyStack().func_190926_b()) {
            Vec3d keyHole = this.getPartPositionAbsoluteVec(this.getProperties().getKeyPortPosition(), 1.0f);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, keyHole.field_72450_a, keyHole.field_72448_b, keyHole.field_72449_c, this.getKeyStack()));
            this.setKeyStack(ItemStack.field_190927_a);
        }
    }

    public boolean isLockable() {
        return true;
    }

    public boolean isEnginePowered() {
        return !(this.getEngineType() != EngineType.NONE && !this.hasEngine() || !this.isControllingPassengerCreative() && !this.isFueled() || this.getDestroyedStage() >= 9 || this.isKeyNeeded() && this.getKeyStack().func_190926_b());
    }

    public boolean canDrive() {
        return (!this.canChangeWheels() || this.hasWheels()) && this.isEnginePowered();
    }

    public boolean isOwner(PlayerEntity player) {
        return this.owner == null || player.func_110124_au().equals(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean hasWheels() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_WHEELS);
    }

    public void setWheels(boolean hasWheels) {
        this.field_70180_af.func_187227_b(HAS_WHEELS, (Object)hasWheels);
    }

    public void setWheelType(WheelType wheelType) {
        this.field_70180_af.func_187227_b(WHEEL_TYPE, (Object)wheelType.ordinal());
    }

    public WheelType getWheelType() {
        return WheelType.values()[(Integer)this.field_70180_af.func_187225_a(WHEEL_TYPE)];
    }

    public void setWheelColor(int color) {
        this.field_70180_af.func_187227_b(WHEEL_COLOR, (Object)color);
    }

    public int getWheelColor() {
        return (Integer)this.field_70180_af.func_187225_a(WHEEL_COLOR);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (!this.field_70170_p.field_72995_K || COLOR.equals(key)) {
            // empty if block
        }
    }

    @Override
    public void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (passenger instanceof PlayerEntity && this.field_70170_p.field_72995_K) {
            VehicleMod.PROXY.playVehicleSound((PlayerEntity)passenger, this);
        }
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (!this.disableFallDamage) {
            super.func_225503_b_(distance, damageMultiplier);
        }
        if (this.launchingTimer <= 0 && distance > 3.0f) {
            this.disableFallDamage = false;
        }
        return true;
    }

    private boolean isControllingPassengerCreative() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).func_184812_l_();
        }
        return false;
    }

    private void openEditInventory(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> buffer.writeInt(this.func_145782_y()));
        }
    }

    public Inventory getVehicleInventory() {
        if (this.vehicleInventory == null) {
            this.initVehicleInventory();
        }
        return this.vehicleInventory;
    }

    protected void initVehicleInventory() {
        this.vehicleInventory = new Inventory(2);
        ItemStack engine = ItemLookup.getEngine(this);
        if (this.getEngineType() != EngineType.NONE & !engine.func_190926_b()) {
            this.vehicleInventory.func_70299_a(0, engine);
        }
        ItemStack wheel = ItemLookup.getWheel(this);
        if (this.canChangeWheels() && !wheel.func_190926_b()) {
            this.vehicleInventory.func_70299_a(1, wheel);
        }
        this.vehicleInventory.func_110134_a((IInventoryChangedListener)this);
    }

    private void updateSlots() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack engine = this.vehicleInventory.func_70301_a(0);
            if (engine.func_77973_b() instanceof EngineItem) {
                EngineItem item = (EngineItem)engine.func_77973_b();
                if (item.getEngineType() == this.getEngineType()) {
                    this.setEngine(true);
                    this.setEngineTier(item.getEngineTier());
                } else {
                    this.setEngine(false);
                }
            } else if (this.getEngineType() != EngineType.NONE) {
                this.setEngine(false);
            }
            ItemStack wheel = this.vehicleInventory.func_70301_a(1);
            if (this.canChangeWheels()) {
                if (wheel.func_77973_b() instanceof WheelItem) {
                    if (!this.hasWheels()) {
                        WheelItem wheelItem = (WheelItem)wheel.func_77973_b();
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)ModSounds.AIR_WRENCH_GUN.get(), SoundCategory.BLOCKS, 1.0f, 1.1f);
                        this.setWheels(true);
                        this.setWheelType(wheelItem.getWheelType());
                        if (wheelItem.hasColor(wheel)) {
                            this.setWheelColor(wheelItem.getColor(wheel));
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.AIR_WRENCH_GUN.get(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                    this.setWheels(false);
                    this.setWheelColor(-1);
                }
            }
        }
    }

    public void func_76316_a(IInventory inventory) {
        this.updateSlots();
    }

    @Override
    protected void onVehicleDestroyed(LivingEntity entity) {
        boolean isCreativeMode;
        super.onVehicleDestroyed(entity);
        boolean bl = isCreativeMode = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_();
        if (!isCreativeMode && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack key;
            ItemStack engine = ItemLookup.getEngine(this);
            if (this.getEngineType() != EngineType.NONE && !engine.func_190926_b()) {
                InventoryUtil.spawnItemStack(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), engine);
            }
            if (!(key = this.getKeyStack().func_77946_l()).func_190926_b()) {
                CommonUtils.getOrCreateStackTag(key).func_82580_o("VehicleId");
                InventoryUtil.spawnItemStack(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), key);
            }
            ItemStack wheel = ItemLookup.getWheel(this);
            if (this.canChangeWheels() && !wheel.func_190926_b()) {
                InventoryUtil.spawnItemStack(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), wheel);
            }
        }
    }

    public boolean canChangeWheels() {
        return true;
    }

    private void updateWheelPositions() {
        VehicleProperties properties = this.getProperties();
        if (properties.getWheels() != null) {
            List<Wheel> wheels = properties.getWheels();
            for (int i = 0; i < wheels.size(); ++i) {
                Wheel wheel = wheels.get(i);
                PartPosition bodyPosition = properties.getBodyPosition();
                double wheelX = bodyPosition.getX();
                double wheelY = bodyPosition.getY();
                double wheelZ = bodyPosition.getZ();
                double scale = bodyPosition.getScale();
                wheelY += (double)(properties.getWheelOffset() * 0.0625f) * scale;
                wheelX += (double)wheel.getOffsetX() * 0.0625 * (double)wheel.getSide().getOffset() * scale;
                wheelY += (double)wheel.getOffsetY() * 0.0625 * scale;
                Vec3d wheelVec = new Vec3d(wheelX += (double)(wheel.getWidth() * wheel.getScaleX() / 2.0f) * 0.0625 * (double)wheel.getSide().getOffset() * scale, wheelY -= 0.15625 * (double)wheel.getScaleY(), wheelZ += (double)wheel.getOffsetZ() * 0.0625 * scale).func_178785_b(-this.getModifiedRotationYaw() * ((float)Math.PI / 180));
                this.wheelPositions[i * 3] = wheelVec.field_72450_a;
                this.wheelPositions[i * 3 + 1] = wheelVec.field_72448_b;
                this.wheelPositions[i * 3 + 2] = wheelVec.field_72449_c;
            }
        }
    }

    public float getWheelModifier() {
        float wheelModifier = 0.0f;
        VehicleProperties properties = this.getProperties();
        List<Wheel> wheels = properties.getWheels();
        if (this.hasWheels() && wheels != null) {
            int wheelCount = 0;
            WheelType type = this.getWheelType();
            for (int i = 0; i < wheels.size(); ++i) {
                int z;
                int y;
                double wheelX = this.wheelPositions[i * 3];
                double wheelY = this.wheelPositions[i * 3 + 1];
                double wheelZ = this.wheelPositions[i * 3 + 2];
                int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() + wheelX));
                BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.func_226278_cu_() + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() + wheelZ)));
                BlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_185904_a() == Material.field_151579_a) continue;
                wheelModifier = state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151596_z || state.func_177230_c() == Blocks.field_196658_i && ((Boolean)state.func_177229_b((IProperty)GrassBlock.field_196382_a)).booleanValue() ? (wheelModifier += 1.0f - type.snowMultiplier) : (!state.func_185904_a().func_76229_l() ? (wheelModifier += 1.0f - type.roadMultiplier) : (wheelModifier += 1.0f - type.dirtMultiplier));
                ++wheelCount;
            }
            if (wheelCount > 0) {
                wheelModifier /= (float)wheelCount;
            }
        }
        return 1.0f - wheelModifier;
    }

    protected void updateGroundState() {
        if (this.hasWheels()) {
            VehicleProperties properties = this.getProperties();
            List<Wheel> wheels = properties.getWheels();
            if (this.hasWheels() && wheels != null) {
                for (int i = 0; i < wheels.size(); ++i) {
                    int z;
                    int y;
                    double wheelX = this.wheelPositions[i * 3];
                    double wheelY = this.wheelPositions[i * 3 + 1];
                    double wheelZ = this.wheelPositions[i * 3 + 2];
                    int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() + wheelX));
                    BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.func_226278_cu_() + wheelY - 0.2)), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() + wheelZ)));
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b()) continue;
                    this.wheelsOnGround = true;
                    return;
                }
            }
            this.wheelsOnGround = false;
        }
    }

    protected boolean canAccelerateInAir() {
        return false;
    }

    protected boolean canCharge() {
        return false;
    }

    protected void releaseCharge() {
        this.boosting = true;
        this.boostTimer = 20;
        this.speedMultiplier = 0.5f;
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        ResourceLocation entityId;
        EngineTier engineTier = null;
        if (this.hasEngine()) {
            engineTier = this.getEngineTier();
        }
        int wheelColor = -1;
        WheelType wheelType = null;
        if (this.hasWheels()) {
            wheelType = this.getWheelType();
            wheelColor = this.getWheelColor();
        }
        if ((entityId = this.func_200600_R().getRegistryName()) != null) {
            return BlockVehicleCrate.create(entityId, this.getColor(), engineTier, wheelType, wheelColor);
        }
        return ItemStack.field_190927_a;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new EditVehicleContainer(windowId, (IInventory)this.getVehicleInventory(), this, playerEntity, playerInventory);
    }

    public static enum FuelPortType {
        DEFAULT(SpecialModels.FUEL_DOOR_CLOSED, SpecialModels.FUEL_DOOR_OPEN, (SoundEvent)ModSounds.FUEL_PORT_OPEN.get(), 0.25f, 0.6f, (SoundEvent)ModSounds.FUEL_PORT_CLOSE.get(), 0.12f, 0.6f),
        SMALL(SpecialModels.SMALL_FUEL_DOOR_CLOSED, SpecialModels.SMALL_FUEL_DOOR_OPEN, (SoundEvent)ModSounds.FUEL_PORT_2_OPEN.get(), 0.4f, 0.6f, (SoundEvent)ModSounds.FUEL_PORT_2_CLOSE.get(), 0.3f, 0.6f);

        private ISpecialModel closed;
        private ISpecialModel open;
        private SoundEvent openSound;
        private SoundEvent closeSound;
        private float openVolume;
        private float closeVolume;
        private float openPitch;
        private float closePitch;

        private FuelPortType(ISpecialModel closed, ISpecialModel open, SoundEvent openSound, float openVolume, float openPitch, SoundEvent closeCount, float closeVolume, float closePitch) {
            this.closed = closed;
            this.open = open;
            this.openSound = openSound;
            this.openVolume = openVolume;
            this.openPitch = openPitch;
            this.closeSound = closeCount;
            this.closeVolume = closeVolume;
            this.closePitch = closePitch;
        }

        public ISpecialModel getClosedModel() {
            return this.closed;
        }

        public ISpecialModel getOpenModel() {
            return this.open;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void playOpenSound() {
            VehicleMod.PROXY.playSound(this.openSound, this.openVolume, this.openPitch);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void playCloseSound() {
            VehicleMod.PROXY.playSound(this.closeSound, this.closeVolume, this.closePitch);
        }
    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE,
        CHARGING;


        public static AccelerationDirection fromEntity(LivingEntity entity) {
            if (entity.field_191988_bg > 0.0f) {
                return FORWARD;
            }
            if (entity.field_191988_bg < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }

    public static enum TurnDirection {
        LEFT(1),
        FORWARD(0),
        RIGHT(-1);

        final int dir;

        private TurnDirection(int dir) {
            this.dir = dir;
        }

        public int getDir() {
            return this.dir;
        }
    }
}

