/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockGasPump;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.util.HermiteInterpolator;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.util.CollisionHelper;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class GasPumpRenderer
extends TileEntityRenderer<GasPumpTileEntity> {
    public GasPumpRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(GasPumpTileEntity gasPump, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        BlockPos blockPos = gasPump.func_174877_v();
        BlockState state = gasPump.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != ModBlocks.GAS_PUMP.get()) {
            return;
        }
        boolean top = (Boolean)state.func_177229_b((IProperty)BlockGasPump.TOP);
        if (!top) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockGasPump.DIRECTION);
        double[] pos = CollisionHelper.fixRotation(facing, 0.640625, 1.078125, 0.640625, 1.078125);
        matrixStack.func_227860_a_();
        if (gasPump.getFuelingEntity() != null) {
            String skinType;
            gasPump.setRecentlyUsed(true);
            PlayerEntity entity = gasPump.getFuelingEntity();
            double side = entity.func_184591_cq() == HandSide.RIGHT ? 1.0 : -1.0;
            double playerX = (double)blockPos.func_177958_n() - (entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)partialTicks);
            double playerY = (double)blockPos.func_177956_o() - (entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)partialTicks);
            double playerZ = (double)blockPos.func_177952_p() - (entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)partialTicks);
            float renderYawOffset = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
            Vec3d lookVec = Vec3d.func_189986_a((float)-20.0f, (float)renderYawOffset);
            Vec3d hoseVec = new Vec3d(-0.35 * side, -0.025, -0.025);
            if (entity instanceof AbstractClientPlayerEntity && (skinType = ((AbstractClientPlayerEntity)entity).func_175154_l()).equals("slim")) {
                hoseVec = hoseVec.func_72441_c(0.03 * side, -0.03, 0.0);
            }
            hoseVec = hoseVec.func_178785_b(-renderYawOffset * ((float)Math.PI / 180));
            if (entity.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                lookVec = Vec3d.func_189986_a((float)0.0f, (float)entity.field_70177_z);
                hoseVec = new Vec3d(-0.25, 0.5, -0.25).func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            }
            HermiteInterpolator.Point destPoint = new HermiteInterpolator.Point(new Vec3d(-playerX + hoseVec.field_72450_a, -playerY + 0.8 + hoseVec.field_72448_b, -playerZ + hoseVec.field_72449_c), new Vec3d(lookVec.field_72450_a * 3.0, lookVec.field_72448_b * 3.0, lookVec.field_72449_c * 3.0));
            gasPump.setCachedSpline(new HermiteInterpolator(new HermiteInterpolator.Point(new Vec3d(pos[0], 0.6425, pos[1]), new Vec3d(0.0, -5.0, 0.0)), destPoint));
        } else if (gasPump.getCachedSpline() == null || gasPump.isRecentlyUsed()) {
            gasPump.setRecentlyUsed(false);
            double[] destPos = CollisionHelper.fixRotation(facing, 0.345, 1.06, 0.345, 1.06);
            HermiteInterpolator.Point destPoint = new HermiteInterpolator.Point(new Vec3d(destPos[0], 0.1, destPos[1]), new Vec3d(0.0, 3.0, 0.0));
            gasPump.setCachedSpline(new HermiteInterpolator(new HermiteInterpolator.Point(new Vec3d(pos[0], 0.6425, pos[1]), new Vec3d(0.0, -5.0, 0.0)), destPoint));
        }
        HermiteInterpolator spline = gasPump.getCachedSpline();
        if (spline != null) {
            float gray;
            float red = gray = 0.1f;
            float hoseDiameter = 0.07f;
            if (gasPump.getFuelingEntity() != null) {
                red = (float)(Math.sqrt(gasPump.getFuelingEntity().func_70092_e((double)gasPump.func_174877_v().func_177958_n() + 0.5, (double)gasPump.func_174877_v().func_177956_o() + 0.5, (double)gasPump.func_174877_v().func_177952_p() + 0.5)) / (Double)Config.SERVER.maxHoseDistance.get());
                red = red * red * red * red * red * red;
                red = Math.max(red, gray);
            }
            RenderSystem.pushMatrix();
            RenderSystem.disableTexture();
            RenderSystem.enableDepthTest();
            RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int segments = (Integer)Config.CLIENT.hoseSegments.get();
            for (int i = 0; i < spline.getSize() - 1; ++i) {
                for (int j = 0; j < segments; ++j) {
                    float percent = (float)j / (float)segments;
                    HermiteInterpolator.Result start = spline.get(i, percent);
                    HermiteInterpolator.Result end = spline.get(i, (float)(j + 1) / (float)segments);
                    Matrix4f startMatrix = new Matrix4f();
                    startMatrix.func_226591_a_();
                    EntityRayTracer.MatrixTransformation.createTranslation((float)start.getPoint().func_82615_a(), (float)start.getPoint().func_82617_b(), (float)start.getPoint().func_82616_c()).transform(startMatrix);
                    if (i == 0 && j == 0) {
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)Math.toDegrees(Math.atan2(end.getDir().field_72450_a, end.getDir().field_72449_c))).transform(startMatrix);
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)Math.toDegrees(Math.asin(-end.getDir().func_72432_b().field_72448_b))).transform(startMatrix);
                    } else {
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)Math.toDegrees(Math.atan2(start.getDir().field_72450_a, start.getDir().field_72449_c))).transform(startMatrix);
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)Math.toDegrees(Math.asin(-start.getDir().func_72432_b().field_72448_b))).transform(startMatrix);
                    }
                    Matrix4f endMatrix = new Matrix4f();
                    endMatrix.func_226591_a_();
                    EntityRayTracer.MatrixTransformation.createTranslation((float)end.getPoint().field_72450_a, (float)end.getPoint().field_72448_b, (float)end.getPoint().field_72449_c).transform(endMatrix);
                    if (i == spline.getSize() - 2 && j == segments - 1) {
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)Math.toDegrees(Math.atan2(start.getDir().field_72450_a, start.getDir().field_72449_c))).transform(endMatrix);
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)Math.toDegrees(Math.asin(-start.getDir().func_72432_b().field_72448_b))).transform(endMatrix);
                    } else {
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)Math.toDegrees(Math.atan2(end.getDir().field_72450_a, end.getDir().field_72449_c))).transform(endMatrix);
                        EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)Math.toDegrees(Math.asin(-end.getDir().func_72432_b().field_72448_b))).transform(endMatrix);
                    }
                    Matrix4f startTemp = new Matrix4f(startMatrix);
                    Matrix4f endTemp = new Matrix4f(endMatrix);
                    Matrix4f parent = matrixStack.func_227866_c_().func_227870_a_();
                    EntityRayTracer.MatrixTransformation.createTranslation(hoseDiameter / 2.0f, -hoseDiameter / 2.0f, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, hoseDiameter, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(hoseDiameter / 2.0f, hoseDiameter / 2.0f, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -hoseDiameter, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0f, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(-hoseDiameter, -hoseDiameter, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0f, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0f, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.0f, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, hoseDiameter, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, hoseDiameter, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0f, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(-hoseDiameter, 0.0f, 0.0f).transform(startTemp);
                    this.createVertex(buffer, parent, startTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.0f, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                    EntityRayTracer.MatrixTransformation.createTranslation(hoseDiameter, 0.0f, 0.0f).transform(endTemp);
                    this.createVertex(buffer, parent, endTemp, red, gray);
                }
            }
            tessellator.func_78381_a();
            RenderSystem.enableTexture();
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
        if (gasPump.getFuelingEntity() == null) {
            matrixStack.func_227860_a_();
            double[] destPos = CollisionHelper.fixRotation(facing, 0.29, 1.06, 0.29, 1.06);
            matrixStack.func_227861_a_(destPos[0], 0.5, destPos[1]);
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)facing.func_176736_b() * -90.0f));
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.8f, 0.8f, 0.8f);
            RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)facing.func_176736_b() * -90.0f));
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        matrixStack.func_227861_a_(0.5, 0.6875, 0.1875);
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, 0.0, (double)0.01f);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.015f, -0.015f, 0.015f);
        FontRenderer fontRenderer = this.field_228858_b_.field_147557_n;
        if (gasPump.getTank() != null) {
            int amount = (int)Math.ceil(100.0 * ((double)gasPump.getTank().getFluidAmount() / (double)gasPump.getTank().getCapacity()));
            String percent = String.format("%d%%", amount);
            int width = fontRenderer.func_78256_a(percent);
            fontRenderer.func_228079_a_(percent, (float)(-width / 2), 10.0f, 0xFFFFFF, false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, light);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0625, 0.0);
        matrixStack.func_227862_a_(0.01f, -0.01f, 0.01f);
        fontRenderer = this.field_228858_b_.field_147557_n;
        int width = fontRenderer.func_78256_a("Fuelium");
        fontRenderer.func_228079_a_("Fuelium", (float)(-width / 2), 10.0f, 9761325, false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    private void createVertex(BufferBuilder buffer, Matrix4f parent, Matrix4f pos, float red, float gray) {
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(pos);
        buffer.func_225582_a_((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c()).func_227885_a_(red, gray, gray, 1.0f).func_181675_d();
    }
}

