/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.RayTraceFunction;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.HelicopterEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.RayTraceResult;

public class RenderHelicopterWrapper<T extends HelicopterEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderHelicopterWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        if (!entity.func_70089_S()) {
            return;
        }
        matrixStack.func_227860_a_();
        VehicleProperties properties = ((VehicleEntity)entity).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)bodyPosition.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)bodyPosition.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)bodyPosition.getRotZ()));
        matrixStack.func_227861_a_(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        matrixStack.func_227862_a_((float)bodyPosition.getScale(), (float)bodyPosition.getScale(), (float)bodyPosition.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, (double)(properties.getAxleOffset() * 0.0625f), 0.0);
        matrixStack.func_227861_a_(0.0, (double)(properties.getWheelOffset() * 0.0625f), 0.0);
        this.renderVehicle.render(entity, matrixStack, renderTypeBuffer, partialTicks, light);
        if (((PoweredVehicleEntity)entity).shouldRenderEngine() && ((PoweredVehicleEntity)entity).hasEngine()) {
            this.renderEngine((PoweredVehicleEntity)entity, properties.getEnginePosition(), RenderUtil.getEngineModel(entity), matrixStack, renderTypeBuffer, light);
        }
        if (((PoweredVehicleEntity)entity).shouldRenderFuelPort() && ((PoweredVehicleEntity)entity).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)entity).getFuelPortType();
            EntityRayTracer.RayTraceResultRotated result = EntityRayTracer.instance().getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(RayTraceFunction.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)entity).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
                ((PoweredVehicleEntity)entity).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)entity).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
            if (!((PoweredVehicleEntity)entity).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), ((PoweredVehicleEntity)entity).getKeyStack(), RenderUtil.getModel(((PoweredVehicleEntity)entity).getKeyStack()), matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            }
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void applyPreRotations(T entity, MatrixStack matrixStack, float partialTicks) {
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(((HelicopterEntity)entity).prevBodyRotationX + (((HelicopterEntity)entity).bodyRotationX - ((HelicopterEntity)entity).prevBodyRotationX) * partialTicks));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(((HelicopterEntity)entity).prevBodyRotationZ + (((HelicopterEntity)entity).bodyRotationZ - ((HelicopterEntity)entity).prevBodyRotationZ) * partialTicks));
    }
}

