<?php

add_action('init', 'register_menus');
function register_menus()
{
    register_nav_menus(
        array(
            'header' => 'Menu główne',
            'footer' => 'Menu dolne'
        )
    );
}

remove_filter('the_content', 'wpautop');


/**
 * Remove the slug from published post permalinks.
 */
function custom_remove_cpt_slug( $post_link, $post, $leavename ) {

    if ( 'adwords' != $post->post_type || 'faq' != $post->post_type || 'publish' != $post->post_status ) {
        return $post_link;
    }

    $post_link = str_replace( '/' . $post->post_type . '/', '/', $post_link );

    return $post_link;
}
add_filter( 'post_type_link', 'custom_remove_cpt_slug', 10, 3 );

remove_filter('wp_head', 'rel_canonical');
remove_filter('wp_head', 'wp_shortlink_wp_head');
function add_canon(){
    $m_url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if (strpos($m_url,'/adwords/') !== false) {
        $nm_url = str_replace('/adwords/', '/', $m_url);
        echo '<link rel="canonical" href="'.$nm_url.'" />';
    }
    else{
        echo '<link rel="canonical" href="'.$m_url.'" />';    
    }
}
add_action( 'wp_head', 'add_canon');

/**
 * Some hackery to have WordPress match postname to any of our public post types
 * All of our public post types can have /post-name/ as the slug, so they better be unique across all posts
 * Typically core only accounts for posts and pages where the slug is /post-name/
 */
function custom_parse_request_tricksy( $query ) {

    // Only noop the main query
    if ( ! $query->is_main_query() )
        return;

    // Only noop our very specific rewrite rule match
    if ( 2 != count( $query->query ) || ! isset( $query->query['page'] ) ) {
        return;
    }

    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
    if ( ! empty( $query->query['name'] ) ) {
        $query->set( 'post_type', array( 'post', 'adwords', 'page', 'faq' ) );
    }
}
add_action( 'pre_get_posts', 'custom_parse_request_tricksy' );

//add_filter('show_admin_bar', '__return_false');

add_action('admin_menu', 'remove_menus', 999);
function remove_menus()
{
 //   remove_menu_page('edit-comments.php');
//    remove_menu_page('plugins.php');
//    remove_menu_page('tools.php');
//    remove_menu_page('edit.php?post_type=acf-field-group');
//    remove_submenu_page('options-general.php', 'scporder-settings');
//    remove_submenu_page('options-general.php', 'wordpress-popular-posts');
//    remove_submenu_page('index.php', 'mpsum-update-options');

//    remove_submenu_page('themes.php', 'theme-editor.php');
//    remove_submenu_page('themes.php', 'themes.php');
    global $submenu;
    unset($submenu['themes.php'][6]); // Customize

//    remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=category');
//    remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=post_tag');
}

/* HIDE PODS */
add_action('admin_menu', 'remove_pods_menu', 11);
function remove_pods_menu()
{
    define('PODS_DISABLE_ADMIN_MENU', true);
    define('PODS_DISABLE_CONTENT_MENU', true);
}

/* REMOVE COMMENTS  */
add_action('init', 'remove_comment_support', 100);
function remove_comment_support()
{
    remove_post_type_support('post', 'comments');
    remove_post_type_support('page', 'comments');
}

/* ADD SEARCH POST TYPE */
function mySearchFilter($query)
{
    if ($query->is_search) {
        $query->set('post_type', array('faq', 'post', 'slownik_pojec'));
        $query->set('posts_per_page', 5);
    };

    return $query;
}

add_filter('pre_get_posts', 'mySearchFilter');

/* POSTS LIST GET PAGE NUMBER FROM QUERY */
function getPaginationPageNumber() {
    global $query_string;

    $query_args = explode("&", $query_string);
    $args = array();

    foreach($query_args as $key => $string) {
        $query_split = explode("=", $string);
        $args[$query_split[0]] = $query_split[1];
    }

    return isset($args['paged']) ? $args['paged'] : false;
}

/* PAGINATION */

function pagination_nav()
{
    global $wp_query, $wp_rewrite;

    // Don't print empty markup if there's only one page.
    if ($wp_query->max_num_pages < 2) {
        return;
    }

    $paged = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
    $pagenum_link = html_entity_decode(get_pagenum_link());
    $query_args = array();
    $url_parts = explode('?', $pagenum_link);

    if (isset($url_parts[1])) {
        wp_parse_str($url_parts[1], $query_args);
    }

    $pagenum_link = remove_query_arg(array_keys($query_args), $pagenum_link);
    $pagenum_link = trailingslashit($pagenum_link) . '%_%';

    $format = $wp_rewrite->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
    $format .= $wp_rewrite->using_permalinks() ? user_trailingslashit($wp_rewrite->pagination_base . '/%#%',
        'paged') : '?paged=%#%';

    // Set up paginated links.
    $links = paginate_links(array(
        'base' => $pagenum_link,
        'format' => $format,
        'total' => $wp_query->max_num_pages,
        'current' => $paged,
        'mid_size' => 1,
        'add_args' => array_map('urlencode', $query_args),
        'prev_text' => 'Poprzednia strona',
        'next_text' => 'Następna strona',
    ));

    if ($links) :

        ?>
        <nav class="navigation paging-navigation" role="navigation">
            <div class="pagination loop-pagination">
                <?php echo $links; ?>
            </div>
            <!-- .pagination -->
        </nav><!-- .navigation -->
    <?php
    endif;
}


function disable_srcset( $sources ) {
return false;
}
add_filter( 'wp_calculate_image_srcset', 'disable_srcset' );

/**
*thumbail
**/
add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 1140, 400 );

/**
*wincyj słów w skrócie
**/

function get_excerpt($count){
  $permalink = get_permalink($post->ID);
  $excerpt = get_the_content();
  $excerpt = strip_tags($excerpt);
  $excerpt = substr($excerpt, 0, $count);
  $excerpt = $excerpt;
  return $excerpt;
}

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */

function lighthouse_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'boczna belka' ),
        'id'            => 'blog',
        'description'   => esc_html__( 'nie wiem co tu napisać' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
        ) );
}
add_action( 'widgets_init', 'lighthouse_widgets_init' );