window.App = window.App || {};
window.App.Contact = (function ($) {
    'use strict';

    $(document).ready(function () {
        var $contact = $('#contact');

        if (!$contact.length) {
            return;
        }

        function initializeMap() {
            var mapCanvas = document.getElementById('map-canvas');
            var lat = parseFloat(mapCanvas.getAttribute('data-lat') || 54.5246764);
            var lng = parseFloat(mapCanvas.getAttribute('data-lng') || 18.5409786);
            var myLatlng = new google.maps.LatLng(lat, lng);

            var mapOptions = {
                scrollwheel: false,
                center: new google.maps.LatLng(lat, lng),
                zoom: 18,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };
            var map = new google.maps.Map(mapCanvas, mapOptions);

            new google.maps.Marker({
                position: myLatlng,
                map: map,
                icon: 'https://drobnicamorska.pl/wp-content/themes/drobnica/pin_d.png'
            });
        }

        google.maps.event.addDomListener(window, 'load', initializeMap);
    });

}(jQuery));