<?php
/*
Plugin Name: MAG Connection Widget
Description: Widget do wyświetlania kosztów połączeń z serwisów Kontener i Drobnicamorska,
Version: 1.0
Author: Foreto Software House, www.foreto.com, Mateusz Laskowski
*/

class mag_connection_widget extends WP_Widget{

	function mag_connection_widget() {
        $widget_ops = array('classname' => 'mag_connection_widget', 'description' => __('Widget do wyświetlania kosztów połączeń z serwisów Kontener, Drobnicamorska i Kolejchiny', 'mag_connection_widget'));
        parent::WP_Widget(false, $name = __('MAG Connection Widget', 'mag_connection_widget'), $widget_ops );
	}

	function form($instance) {	
        if( $instance) {
             $firstPageConnections = esc_attr($instance['firstPageConnections']);
             $secondPageConnections = esc_attr($instance['secondPageConnections']);
        } else {
             $firstPageConnections = '';
             $secondPageConnections = '';
        }
        
        ?>
            <p>
                Medota wprowadzania połączeń: <br>
                Gdańsk - Yantian, Ho Chi Minh - Gdańsk, Gdańsk - Yantian<br>
                Należy przestrzegać ilości użytych spacji i wielkości liter.
            </p>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id('firstPageConnections') ); ?>"><?php _e('Połączenia dla kontener:', 'mag_connection_widget'); ?></label>
                <textarea style="width: 100%; height: 200px;" id="<?php echo esc_attr( $this->get_field_id('firstPageConnections') ); ?>" name="<?php echo esc_attr( $this->get_field_name('firstPageConnections') ); ?>"><?php echo esc_html( $firstPageConnections ); ?></textarea>
            </p>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id('secondPageConnections') ); ?>"><?php _e('Połączenia dla drobnicamorska:', 'mag_connection_widget'); ?></label>
                <textarea style="width: 100%; height: 200px;" id="<?php echo esc_attr( $this->get_field_id('secondPageConnections') ); ?>" name="<?php echo esc_attr( $this->get_field_name('secondPageConnections') ); ?>"><?php echo esc_html( $secondPageConnections ); ?></textarea>
            </p>
        <?php
	}

	function update($new_instance, $old_instance){
          $instance = $old_instance;
          // Fields
          $instance['firstPageConnections'] = strip_tags($new_instance['firstPageConnections']);
          $instance['secondPageConnections'] = strip_tags($new_instance['secondPageConnections']);
         return $instance;
	}

	// widget display
	function widget($args, $instance){
        extract($args);
        
        $firstPageConnections = $instance['firstPageConnections'];
        $secondPageConnections = $instance['secondPageConnections'];
        $firstPage = false;
        $secondPage = false;
        $firstPage = 'http://kontener.pl/fracht/';
        $secondPage = 'http://drobnicamorska.pl/fracht/';
        $todayDate = date('Ymd');
        $yesterdayDate = date('Ymd', strtotime('-1 day'));
        $ext = '.json';
        $todayJson = $todayDate.$ext;
        $yesterdayJson = $yesterdayDate.$ext;
        $opt = array(
            'Transport morski kontenerów',
            'Transport morski drobnicy',
        );
        
        if($firstPageConnections){
            $firstPageConnections = array_map('trim', explode(',', $firstPageConnections));
            $firstPageContent = ($this->checkIfFileExist($firstPage.$todayJson)) ? @file_get_contents($firstPage.$todayJson) : ($this->checkIfFileExist($firstPage.$yesterdayJson)) ? @file_get_contents($firstPage.$yesterdayJson) : false;
        }
        
        if($secondPageConnections){
            $secondPageConnections = array_map('trim', explode(',', $secondPageConnections));
            $secondPageContent = ($this->checkIfFileExist($secondPage.$todayJson)) ? @file_get_contents($secondPage.$todayJson) : ($this->checkIfFileExist($secondPage.$yesterdayJson)) ? @file_get_contents($secondPage.$yesterdayJson) : false;  
        }
        
        echo $before_widget;
        
        if($firstPageContent){
            echo '<h3>'.$opt[0].'</h3>';        
            $sectionContent = json_decode($firstPageContent);
            $output = array();
            
//            portZaladunku
//            portWyladunku
//            frachtMorski
//            typKontenera
            
            foreach($sectionContent as $key => $value){
                $portsRelation = $value->portZaladunku.' - '.$value->portWyladunku;
                $containerRelation = $value->typKontenera;
                $costRelation = $value->frachtMorski;

                $output[$portsRelation][$containerRelation] = $costRelation;  
            }
            ?>
                <ul class="mag_connection_widget_list mag_connection_widget_kontener">
                    <li>
                        <span class="mag_connection_widget_title"></span>
                        <span class="mag_connection_widget_cost"><strong>20'DV</strong></span>
                        <span class="mag_connection_widget_cost"><strong>40'DV</strong></span>
                        <span class="mag_connection_widget_cost"><strong>40'HC</strong></span>
                        <span class="mag_connection_widget_link"></span>
                    </li>
            <?php
                foreach($output as $connection => $container){
                    if(!in_array($connection, $firstPageConnections)){
                        continue;    
                    }   
            ?>        
                    
                    <li>
                        <span class="mag_connection_widget_title">
                            <?php echo $connection; ?>
                        </span>   
                        <span class="mag_connection_widget_cost">
                            <?php echo (isset($container['20DV']) ? floor($container['20DV']) : ''); ?>&#36;
                        </span>
                        <span class="mag_connection_widget_cost">
                            <?php echo (isset($container['40DV']) ? floor($container['40DV']) : ''); ?>&#36;
                        </span>
                        <span class="mag_connection_widget_cost">
                            <?php echo (isset($container['40HC']) ? floor($container['40HC']) : ''); ?>&#36;
                        </span>   
            <?php
                        $connection = array_map('trim',explode('-', $connection));         
            ?>
                        <span class="mag_connection_widget_link">
                            <a class="mag_connection_widget_kontener_color" href="http://kontener.pl?f=<?php echo $connection[0]; ?>&t=<?php echo $connection[1]; ?>" target="_blank"><span>></span></a>
                        </span>
                    </li>
            <?php
                }
            ?>
                </ul>
                <p class="mag_connection_widget_source">(źródło: <a class="mag_connection_widget_kontener_color" href="http://kontener.pl" target="_blank">www.kontener.pl</a>)</p>
            <?php
        }
        
        if($secondPageContent){
            echo '<h3>'.$opt[1].'</h3>';
            $sectionContent = json_decode($secondPageContent);
            $output = array();
            
//            portZaladunku
//            portWyladunku
//            frachtMorski

            foreach($sectionContent as $key => $value){
                $portsRelation = $value->portZaladunku.' - '.$value->portWyladunku;
                $costRelation = $value->frachtMorski;

                $output[$portsRelation] = $costRelation;  
            }
            ?>
                <ul class="mag_connection_widget_list mag_connection_widget_drobnica">
                    <li>
                        <span class="mag_connection_widget_title"></span>
                        <span class="mag_connection_widget_cost"><strong>1 m&sup3; lub 1 tona</strong></span>
                        <span class="mag_connection_widget_link"></span>
                    </li>
            <?php
                foreach($output as $connection => $cost){
                    if(!in_array($connection, $secondPageConnections)){
                        continue;    
                    }   
            ?>                        
                    <li>
                        <span class="mag_connection_widget_title">
                            <?php echo $connection; ?>
                        </span>
                        <span class="mag_connection_widget_cost">
                            <?php echo floor($cost); ?>&#36;
                        </span> 
            <?php
                        $connection = array_map('trim',explode('-', $connection));         
            ?>
                        <span class="mag_connection_widget_link">
                            <a class="mag_connection_widget_drobnica_color" href="http://drobnicamorska.pl?f=<?php echo $connection[0]; ?>&t=<?php echo $connection[1]; ?>" target="_blank"><span>></span></a>
                        </span>
                    </li>
            <?php
                }
            ?>
                </ul>
                <p class="mag_connection_widget_source">(źródło: <a class="mag_connection_widget_drobnica_color" href="http://drobnicamorska.pl" target="_blank">www.drobnicamorska.pl</a>)</p>
            <?php 
        }       
        
        echo $after_widget;
        ?>
            <style>
                .mag_connection_widget_kontener_color{
                    color: #FF8900 !important;    
                }
                .mag_connection_widget_drobnica_color{
                    color: #33C7CE !important;    
                }
                .mag_connection_widget_list{
                    list-style: none; 
                    padding: 0; 
                    margin: 0 !important; 
                }
                .mag_connection_widget_source{
                    font-size: 8px;
                    line-height: 26px;
                    text-align: right;
                    margin: 0;
                }
                .mag_connection_widget_source a:hover{
                    text-decoration: underline;    
                }
                .mag_connection_widget_list li{
                    clear: both;   
                    height: 26px;
                    display: block;
                    background: none !important;
                    border: none !important;
                    padding: 0 !important;
                }
                .mag_connection_widget_title,
                .mag_connection_widget_link,
                .mag_connection_widget_cost{
                    float: left;  
                    font-size: 12px;
                    line-height: 26px;
                    height: 26px;
                }
                .mag_connection_widget_cost{
                    text-align: center;    
                }
                .mag_connection_widget_link{
                    font-weight: bold;
                    font-size: 14px;
                    text-align: right;   
                }
                .mag_connection_widget_link span{
                    -webkit-transition: transform 0.2s;
                    transition: transform 0.2s;     
                }
                .mag_connection_widget_link:hover span{
                    display: inline-block;
                    -ms-transform: translateX(-2px);
                    -webkit-transform: translateX(-2px);
                    transform: translateX(-2px);    
                }
                .mag_connection_widget_kontener .mag_connection_widget_title{
                    width: 52%;
                }
                .mag_connection_widget_kontener .mag_connection_widget_cost{           
                    width: 14%;
                }
                .mag_connection_widget_kontener .mag_connection_widget_link{
                    width: 6%;
                }
                .mag_connection_widget_drobnica .mag_connection_widget_title{
                    width: 52%;
                }
                .mag_connection_widget_drobnica .mag_connection_widget_cost{  
                    width: 42%;
                }
                .mag_connection_widget_drobnica .mag_connection_widget_link{
                    width: 6%;
                }
            </style>
        <?php
	}
    
    private function checkIfFileExist($httpAddress){
        $file = $httpAddress;
        $file_headers = @get_headers($file);
        if($file_headers[0] == 'HTTP/1.1 404 Not Found') {
            $exists = false;
        }
        else {
            $exists = true;
        }
        return $exists;
    }
}


add_action('widgets_init', create_function('', 'return register_widget("mag_connection_widget");'));
?>