<?php

namespace AppBundle\Service;

use AppBundle\Entity\User;
use Symfony\Component\Security\Core\Encoder\EncoderFactory;

class PasswordService
{
    /**
     * @var EncoderFactory
     */
    private $encoderFactory;

    public function __construct(EncoderFactory $encoderFactory)
    {
        $this->encoderFactory = $encoderFactory;
    }

    /**
     * @param User $user
     * @return string
     */
    public function setRandomPassword(User $user)
    {
        $password = $this->generateRandomString();
        $this->setEncodedPassword($user, $password);

        return $password;
    }

    /**
     * @param User $user
     * @param $password
     */
    public function setEncodedPassword(User $user, $password)
    {
        $encoder = $this->encoderFactory->getEncoder(new User());
        $encodedPassword = $encoder->encodePassword($password, $user->getSalt());
        $user->setPassword($encodedPassword);
    }

    /**
     * @return string
     */
    private function generateRandomString()
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*";
        return substr(str_shuffle($chars), 0, 8);
    }
} 