<?php

namespace AppBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class UserType extends AbstractType
{
    private $isUserAccount;

    public function __construct($isUserAccount = false)
    {
        $this->isUserAccount = $isUserAccount;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'fullName',
                null,
                array(
                    'label' => 'Imie i nazwisko'
                )
            )
            ->add(
                'email',
                null,
                array(
                    'label' => 'Adres email'
                )
            );

        if($this->isUserAccount) {
            $builder
                ->add(
                    'password',
                    'password',
                    array(
                        'label' => 'Stare hasło',
                        'required' => false
                    )
                )
                ->add(
                    'newPassword',
                    'repeated',
                    array(
                        'first_options' => array(
                            'label' => 'Nowe Hasło'
                        ),
                        'second_options' => array(
                            'label' => 'Potwórz nowe hasło'
                        ),
                        'type' => 'password',
                        'required' => false,
                        'invalid_message' => 'Hasła nie są identyczne.'
                    )
                );
        }
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $validationGroups = array('group');
        if($this->isUserAccount) {
            $validationGroups[] = 'with_password';
        }

        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\User',
                    'validation_groups' => $validationGroups,
                )
            );
    }

    public function getName()
    {
        return 'user';
    }
}