<?php

namespace AppBundle\Form\Type;

use AppBundle\Form\DataTransformer\PortToIdTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\NotNull;

class OrderThirdType extends AbstractType
{
    private $isForwarded;

    public function __construct($isForwarded)
    {
        $this->isForwarded = $isForwarded;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $entityManager = $options['em'];
        $transformer = new PortToIdTransformer($entityManager);

        $builder
            ->add(
                $builder->create('loading', 'hidden')
                    ->addModelTransformer($transformer)
            )
            ->add(
                $builder->create('unloading', 'hidden')
                    ->addModelTransformer($transformer)
            )
            ->add(
                'loadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'unloadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'volume',
                'hidden'
            )
            ->add(
                'weight',
                'hidden'
            )
            ->add(
                'customs',
                'hidden'
            )
            ->add(
                'transport',
                'hidden'
            )
            ->add(
                'city',
                'hidden'
            )
            ->add(
                'postalCode',
                'hidden'
            )
            ->add(
                'firstDimension',
                'hidden'
            )
            ->add(
                'secondDimension',
                'hidden'
            )
            ->add(
                'thirdDimension',
                'hidden'
            )
            ->add(
                'quantity',
                'hidden'
            )
            ->add(
                'quantityType',
                'hidden'
            )
            ->add(
                'voucher',
                'text',
                array(
                    'label' => 'Kupon rabatowy',
                    'required' => false,
                    'mapped' => false
                )
            )
            ->add(
                'fullName',
                'text',
                array(
                    'label' => 'Imię i nazwisko'
                )
            )
            ->add(
                'company',
                'text',
                array(
                    'label' => 'Nazwa firmy',
                    'required' => false
                )
            )
            ->add(
                'phone',
                'text',
                array(
                    'label' => 'Telefon',
                    'required' => false
                )
            )
            ->add(
                'email',
                'text',
                array(
                    'label' => 'Email'
                )
            )
            ->add(
                'rules',
                'checkbox',
                array(
                    'label' => 'Akceptuje regulamin',
                    'mapped' => false,
                    'constraints' => array(
                        new NotBlank(array(
                            'groups' => array('third')
                        ))
                    )
                )
            );

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Application',
                    'validation_groups' => $this->isForwarded ? array('second') : array('third'),
                    'csrf_protection' => false
                )
            )
            ->setRequired(array('em'))
            ->setAllowedTypes('em', 'Doctrine\Common\Persistence\ObjectManager');
    }

    public function getName()
    {
        return 'order';
    }
}