<?php

namespace AppBundle\Form\Type;

use AppBundle\Form\DataTransformer\PortToIdTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class OrderSecondType extends AbstractType
{
    private $isForwarded;

    public function __construct($isForwarded)
    {
        $this->isForwarded = $isForwarded;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $entityManager = $options['em'];
        $transformer = new PortToIdTransformer($entityManager);

        $builder
            ->add(
                $builder->create('loading', 'hidden')
                    ->addModelTransformer($transformer)
            )
            ->add(
                $builder->create('unloading', 'hidden')
                    ->addModelTransformer($transformer)
            )
            ->add(
                'loadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'unloadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'volume',
                'hidden'
            )
            ->add(
                'weight',
                'hidden'
            )
            ->add(
                'documentary',
                'checkbox',
                array(
                    'label' => 'Opłata dokumentacyjna',
                    'data' => true,
                    'disabled' => true,
                    'mapped' => false
                )
            )
            ->add(
                'warehouse',
                'checkbox',
                array(
                    'label' => 'Koszty magazynowe',
                    'data' => true,
                    'disabled' => true,
                    'mapped' => false
                )
            )
            ->add(
                'thc',
                'checkbox',
                array(
                    'label' => 'Koszty terminalowe THC',
                    'data' => true,
                    'disabled' => true,
                    'mapped' => false
                )
            )
            ->add(
                'isps',
                'checkbox',
                array(
                    'label' => 'Podjęcie z magazynu',
                    'data' => true,
                    'disabled' => true,
                    'mapped' => false
                )
            )
            ->add(
                'customs',
                'checkbox',
                array(
                    'label' => 'Odprawa celna',
                    'required' => false
                )
            )
            ->add(
                'transport',
                'checkbox',
                array(
                    'label' => 'Transport drogowy',
                    'required' => false
                )
            )
            ->add(
                'city',
                'text',
                array(
                    'label' => 'Miasto',
                    'required' => false
                )
            )
            ->add(
                'postalCode',
                'text',
                array(
                    'label' => 'Kod pocztowy',
                    'required' => false
                )
            )
            ->add(
                'firstDimension',
                'number',
                array(
                    'label' => false,
                    'required' => false,
                    'attr' => array(
                        'placeholder' => 'dł'
                    )
                )
            )
            ->add(
                'secondDimension',
                'number',
                array(
                    'label' => false,
                    'required' => false,
                    'attr' => array(
                        'placeholder' => 'szer'
                    )
                )
            )
            ->add(
                'thirdDimension',
                'number',
                array(
                    'label' => false,
                    'required' => false,
                    'attr' => array(
                        'placeholder' => 'wys'
                    )
                )
            )
            ->add(
                'quantity',
                'number',
                array(
                    'label' => 'Ilość sztuk',
                    'precision' => 0,
                    'required' => false
                )
            )
            ->add(
                'quantityType',
                'choice',
                array(
                    'label' => 'Typ',
                    'choices' => array(
                        'pallets' => 'palety',
                        'packages' => 'kartony/paczki',
                        'unknown' => 'nie wiem'
                    ),
                    'placeholder' => false,
                    'required' => false
                )
            );

    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Application',
                    'validation_groups' => $this->isForwarded ? array('first') : array('second'),
                    'csrf_protection' => false
                )
            )
            ->setRequired(array('em'))
            ->setAllowedTypes('em', 'Doctrine\Common\Persistence\ObjectManager');
    }

    public function getName()
    {
        return 'order';
    }
}