<?php

namespace AppBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class OrderFirstType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'loading',
                'entity',
                array(
                    'label' => 'Port załadunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectFormWithLoadings('Polska'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'unloading',
                'entity',
                array(
                    'label' => 'Port rozładunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectFormWithUnloadings('Polska'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'loadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'unloadingCopy',
                'hidden',
                array(
                    'mapped' => false
                )
            )
            ->add(
                'volume',
                'number',
                array(
                    'label' => 'Objętość (m3)',
                    'attr' => array(
                        'placeholder' => '1.00'
                    ),
                    'precision' => 3
                )
            )
            ->add(
                'weight',
                'hidden',
                array(
                    'attr' => array(
                        'placeholder' => '1000'
                    )
                )
            );
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Application',
                    'validation_groups' => array('first'),
                    'csrf_protection' => false
                )
            )
            ->setRequired(array('em'))
            ->setAllowedTypes('em', 'Doctrine\Common\Persistence\ObjectManager');
    }

    public function getName()
    {
        return 'order';
    }
}