<?php

namespace AppBundle\Form\Type;

use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ConnectionType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'loading',
                'entity',
                array(
                    'label' => 'Port załadunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectForm('Chiny'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'unloading',
                'entity',
                array(
                    'label' => 'Port rozładunku',
                    'class' => 'AppBundle:Port',
                    'choices' => $options['em']->getRepository('AppBundle:Port')->findForSelectForm('Polska'),
                    'property' => 'name',
                    'group_by' => 'country',
                    'empty_value' => ''
                )
            )
            ->add(
                'cost',
                'number',
                array(
                    'label' => 'Koszt',
                    'precision' => 2
                )
            )
            ->add(
                'validTo',
                'datetime',
                array(
                    'label' => 'Termin ważności',
                    'widget' => 'single_text',
                    'format' => 'dd-MM-yyyy HH:m'
                )
            )
            ->add('useeuro', 'checkbox', array(
                'label'    => 'Opłaty w euro?',
                'required' => false,
              )
            )
            ->add(
                'referrer',
                'hidden',
                array(
                    'mapped' => false
                )
            );
    }

    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver
            ->setDefaults(
                array(
                    'data_class' => 'AppBundle\Entity\Connection',

                )
            )
            ->setRequired(array('em'))
            ->setAllowedTypes('em', 'Doctrine\Common\Persistence\ObjectManager');
    }

    public function getName()
    {
        return 'connection';
    }
}
