<?php

namespace AppBundle\Form\DataTransformer;

use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Exception\TransformationFailedException;
use Doctrine\Common\Persistence\ObjectManager;
use AppBundle\Entity\Port;

class PortToIdTransformer implements DataTransformerInterface
{
    /**
     * @var ObjectManager
     */
    private $om;

    /**
     * @param ObjectManager $om
     */
    public function __construct(ObjectManager $om)
    {
        $this->om = $om;
    }

    /**
     * @param mixed $port
     * @return string
     */
    public function transform($port)
    {
        if (null === $port) {
            return "";
        }

        return $port->getId();
    }

    /**
     * @param mixed $id
     * @return Port|null
     */
    public function reverseTransform($id)
    {
        if (!$id) {
            return null;
        }

        $port = $this->om
            ->getRepository('AppBundle:Port')
            ->findOneBy(array('id' => $id));

        if (null === $port) {
            throw new TransformationFailedException(sprintf(
                'An port with id "%s" does not exist!',
                $id
            ));
        }

        return $port;
    }
}