<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\Voucher;
use Doctrine\ORM\EntityRepository;

class VoucherHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('vh')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(Voucher $voucher)
    {
        return $this
            ->createQueryBuilder('vh')
            ->where('vh.voucher = :voucher')
            ->setParameter('voucher', $voucher)
            ->getQuery();
    }
}
