<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\User;
use Doctrine\ORM\EntityRepository;

class UserHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('uh')
            ->getQuery();
    }

    /**
     * @param User $user
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(User $user)
    {
        return $this
            ->createQueryBuilder('uh')
            ->where('uh.user = :user')
            ->setParameter('user', $user)
            ->getQuery();
    }
}
