<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

class SettingRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('s')
            ->where('s.isRemoved != true')
            ->orWhere('s.isRemoved IS NULL')
            ->getQuery();
    }

    public function findAllData()
    {
        $settings = $this
            ->createQueryBuilder('s')
            ->getQuery()
            ->getResult();

        $settingsBySlug = array();

        foreach ($settings as $setting) {
            $settingsBySlug[$setting->getSlug()] = $setting->getValue();
        }

        return $settingsBySlug;
    }
    
    public function portAllMyData(){
         $stmt = $this->getEntityManager()
           ->getConnection()
           ->prepare('select * from port');
        $stmt->execute();
        $result = $stmt->fetchAll();
        return $result;
    }
}
