<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\Setting;
use Doctrine\ORM\EntityRepository;

class SettingHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('sh')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(Setting $setting)
    {
        return $this
            ->createQueryBuilder('sh')
            ->where('sh.setting = :setting')
            ->setParameter('setting', $setting)
            ->getQuery();
    }
}
