<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\SettingEuro;
use Doctrine\ORM\EntityRepository;

class SettingEuroHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('sh')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(SettingEuro $setting)
    {
        return $this
            ->createQueryBuilder('sh')
            ->where('sh.setting = :setting')
            ->setParameter('setting', $setting)
            ->getQuery();
    }
}
