<?php

namespace AppBundle\Entity\Repository;

use AppBundle\Entity\Port;
use Doctrine\ORM\EntityRepository;

class PortRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('p')
            ->where('p.isRemoved != true')
            ->orWhere('p.isRemoved IS NULL')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getRemovedListQuery()
    {
        return $this
            ->createQueryBuilder('p')
            ->where('p.isRemoved = true')
            ->getQuery();
    }

    /**
     * @return mixed
     */
    public function findForSelectForm($firstCountry)
    {
        $em = $this->getEntityManager();

        return $em->createQuery(
            "
            SELECT p, (CASE WHEN p.country = :firstCountry then 1 ELSE 0 END) as HIDDEN country FROM AppBundle:Port p
            WHERE p.isRemoved != true OR p.isRemoved IS NULL
            ORDER BY
            country DESC,
            p.country ASC,
            p.name ASC
            "
        )
            ->setParameter('firstCountry', $firstCountry)
            ->getResult();
    }


    /**
     * @return mixed
     */
    public function findForSelectFormWithLoadings($firstCountry)
    {
        $em = $this->getEntityManager();

        return $em->createQuery(
            "
            SELECT p, (CASE WHEN p.country = :firstCountry then 1 ELSE 0 END) as HIDDEN country FROM AppBundle:Port p
            LEFT JOIN p.loadings loadings
            WHERE
                loadings.validTo >= :validTo
                AND
                (p.isRemoved != true OR p.isRemoved IS NULL)
                AND
                (loadings.id IS NOT NULL AND (loadings.isRemoved != true OR loadings.isRemoved IS NULL))
            ORDER BY
            country DESC,
            p.country ASC,
            p.name ASC
            "
        )
            ->setParameter('firstCountry', $firstCountry)
            ->setParameter('validTo', new \DateTime())
            ->getResult();
    }

    /**
     * @return mixed
     */
    public function findForSelectFormWithUnloadings($firstCountry)
    {
        $em = $this->getEntityManager();

        return $em->createQuery(
            "
            SELECT p, (CASE WHEN p.country = :firstCountry then 1 ELSE 0 END) as HIDDEN country FROM AppBundle:Port p
            LEFT JOIN p.unloadings unloadings
            WHERE
                unloadings.validTo >= :validTo
                AND
                (p.isRemoved != true OR p.isRemoved IS NULL)
                AND
                (unloadings.id IS NOT NULL AND (unloadings.isRemoved != true OR unloadings.isRemoved IS NULL))
            ORDER BY
            country DESC,
            p.country ASC,
            p.name ASC
            "
        )
            ->setParameter('firstCountry', $firstCountry)
            ->setParameter('validTo', new \DateTime())
            ->getResult();
    }

    /**
     * @return Port[]
     */
    public function findNotRemoved()
    {
        return $this
            ->createQueryBuilder('p')
            ->where('p.isRemoved != true')
            ->orWhere('p.isRemoved IS NULL')
            ->getQuery()
            ->getResult();
    }
}
