<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;
use AppBundle\Entity\Port;

class PortHistoryRepository extends EntityRepository
{
    /**
     * @return \Doctrine\ORM\Query
     */
    public function getListQuery()
    {
        return $this
            ->createQueryBuilder('ph')
            ->getQuery();
    }

    /**
     * @return \Doctrine\ORM\Query
     */
    public function getHistoryListQuery(Port $port)
    {
        return $this
            ->createQueryBuilder('ph')
            ->where('ph.port = :port')
            ->setParameter('port', $port)
            ->getQuery();
    }
}
