<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Port
 */
class Port
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $country;

    /**
     * @var boolean
     */
    private $isRemoved;

    /**
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $loadings;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $unloadings;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->loadings = new \Doctrine\Common\Collections\ArrayCollection();
        $this->unloadings = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Port
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set country
     *
     * @param string $country
     * @return Port
     */
    public function setCountry($country)
    {
        $this->country = $country;

        return $this;
    }

    /**
     * Get country
     *
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * Set isRemoved
     *
     * @param boolean $isRemoved
     * @return Port
     */
    public function setIsRemoved($isRemoved)
    {
        $this->isRemoved = $isRemoved;

        return $this;
    }

    /**
     * Get isRemoved
     *
     * @return boolean 
     */
    public function getIsRemoved()
    {
        return $this->isRemoved;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     * @return Port
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return Port
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Add loadings
     *
     * @param \AppBundle\Entity\Connection $loadings
     * @return Port
     */
    public function addLoading(\AppBundle\Entity\Connection $loadings)
    {
        $this->loadings[] = $loadings;

        return $this;
    }

    /**
     * Remove loadings
     *
     * @param \AppBundle\Entity\Connection $loadings
     */
    public function removeLoading(\AppBundle\Entity\Connection $loadings)
    {
        $this->loadings->removeElement($loadings);
    }

    /**
     * Get loadings
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getLoadings()
    {
        return $this->loadings;
    }

    /**
     * Add unloadings
     *
     * @param \AppBundle\Entity\Connection $unloadings
     * @return Port
     */
    public function addUnloading(\AppBundle\Entity\Connection $unloadings)
    {
        $this->unloadings[] = $unloadings;

        return $this;
    }

    /**
     * Remove unloadings
     *
     * @param \AppBundle\Entity\Connection $unloadings
     */
    public function removeUnloading(\AppBundle\Entity\Connection $unloadings)
    {
        $this->unloadings->removeElement($unloadings);
    }

    /**
     * Get unloadings
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUnloadings()
    {
        return $this->unloadings;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtAsNow()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreFlush
     */
    public function setUpdatedAtAsNow()
    {
        $this->updatedAt = new \DateTime();
    }
}
