<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ConnectionHistory
 */
class ConnectionHistory
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var float
     */
    private $cost;

    /**
     * @var \DateTime
     */
    private $validTo;

    /**
     * @var boolean
     */
    private $isRemoved;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $loading;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $unloading;

    /**
     * @var \AppBundle\Entity\Connection
     */
    private $connection;

    /**
     * @var \AppBundle\Entity\User
     */
    private $user;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cost
     *
     * @param float $cost
     * @return ConnectionHistory
     */
    public function setCost($cost)
    {
        $this->cost = $cost;

        return $this;
    }

    /**
     * Get cost
     *
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * Set validTo
     *
     * @param \DateTime $validTo
     * @return ConnectionHistory
     */
    public function setValidTo($validTo)
    {
        $this->validTo = $validTo;

        return $this;
    }

    /**
     * Get validTo
     *
     * @return \DateTime
     */
    public function getValidTo()
    {
        return $this->validTo;
    }

    /**
     * Set isRemoved
     *
     * @param boolean $isRemoved
     * @return ConnectionHistory
     */
    public function setIsRemoved($isRemoved)
    {
        $this->isRemoved = $isRemoved;

        return $this;
    }

    /**
     * Get isRemoved
     *
     * @return boolean
     */
    public function getIsRemoved()
    {
        return $this->isRemoved;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return ConnectionHistory
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set loading
     *
     * @param \AppBundle\Entity\Port $loading
     * @return ConnectionHistory
     */
    public function setLoading(\AppBundle\Entity\Port $loading = null)
    {
        $this->loading = $loading;

        return $this;
    }

    /**
     * Get loading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getLoading()
    {
        return $this->loading;
    }

    /**
     * Set unloading
     *
     * @param \AppBundle\Entity\Port $unloading
     * @return ConnectionHistory
     */
    public function setUnloading(\AppBundle\Entity\Port $unloading = null)
    {
        $this->unloading = $unloading;

        return $this;
    }

    /**
     * Get unloading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getUnloading()
    {
        return $this->unloading;
    }

    /**
     * Set connection
     *
     * @param \AppBundle\Entity\Connection $connection
     * @return ConnectionHistory
     */
    public function setConnection(\AppBundle\Entity\Connection $connection = null)
    {
        $this->connection = $connection;

        return $this;
    }

    /**
     * Get connection
     *
     * @return \AppBundle\Entity\Connection
     */
    public function getConnection()
    {
        return $this->connection;
    }

    /**
     * Set user
     *
     * @param \AppBundle\Entity\User $user
     * @return ConnectionHistory
     */
    public function setUser(\AppBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \AppBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtAsNow()
    {
        $this->createdAt = new \DateTime();
    }
}
