<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Application
 */
class Application
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var float
     */
    private $volume;

    /**
     * @var float
     */
    private $weight;

    /**
     * @var float
     */
    private $documentary;

    /**
     * @var float
     */
    private $thc;

    /**
     * @var float
     */
    private $isps;

    /**
     * @var float
     */
    private $customs;

    /**
     * @var boolean
     */
    private $transport;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $postalCode;

    /**
     * @var float
     */
    private $firstDimension;

    /**
     * @var float
     */
    private $secondDimension;

    /**
     * @var float
     */
    private $thirdDimension;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @var float
     */
    private $cost;

    /**
     * @var string
     */
    private $fullName;

    /**
     * @var string
     */
    private $company;

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $email;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $loading;

    /**
     * @var \AppBundle\Entity\Port
     */
    private $unloading;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set volume
     *
     * @param float $volume
     * @return Application
     */
    public function setVolume($volume)
    {
        $this->volume = $volume;

        return $this;
    }

    /**
     * Get volume
     *
     * @return float
     */
    public function getVolume()
    {
        return $this->volume;
    }

    /**
     * Set weight
     *
     * @param float $weight
     * @return Application
     */
    public function setWeight($weight)
    {
        $this->weight = $weight;

        return $this;
    }

    /**
     * Get weight
     *
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * Set documentary
     *
     * @param float $documentary
     * @return Application
     */
    public function setDocumentary($documentary)
    {
        $this->documentary = $documentary;

        return $this;
    }

    /**
     * Get documentary
     *
     * @return float
     */
    public function getDocumentary()
    {
        return $this->documentary;
    }

    /**
     * Set thc
     *
     * @param float $thc
     * @return Application
     */
    public function setThc($thc)
    {
        $this->thc = $thc;

        return $this;
    }

    /**
     * Get thc
     *
     * @return float
     */
    public function getThc()
    {
        return $this->thc;
    }

    /**
     * Set isps
     *
     * @param float $isps
     * @return Application
     */
    public function setIsps($isps)
    {
        $this->isps = $isps;

        return $this;
    }

    /**
     * Get isps
     *
     * @return float
     */
    public function getIsps()
    {
        return $this->isps;
    }

    /**
     * Set customs
     *
     * @param float $customs
     * @return Application
     */
    public function setCustoms($customs)
    {
        $this->customs = $customs;

        return $this;
    }

    /**
     * Get customs
     *
     * @return float
     */
    public function getCustoms()
    {
        return $this->customs;
    }

    /**
     * Set transport
     *
     * @param boolean $transport
     * @return Application
     */
    public function setTransport($transport)
    {
        $this->transport = $transport;

        return $this;
    }

    /**
     * Get transport
     *
     * @return boolean
     */
    public function getTransport()
    {
        return $this->transport;
    }

    /**
     * Set city
     *
     * @param string $city
     * @return Application
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * Get city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Set postalCode
     *
     * @param string $postalCode
     * @return Application
     */
    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;

        return $this;
    }

    /**
     * Get postalCode
     *
     * @return string
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }

    /**
     * Set firstDimension
     *
     * @param float $firstDimension
     * @return Application
     */
    public function setFirstDimension($firstDimension)
    {
        $this->firstDimension = $firstDimension;

        return $this;
    }

    /**
     * Get firstDimension
     *
     * @return float
     */
    public function getFirstDimension()
    {
        return $this->firstDimension;
    }

    /**
     * Set secondDimension
     *
     * @param float $secondDimension
     * @return Application
     */
    public function setSecondDimension($secondDimension)
    {
        $this->secondDimension = $secondDimension;

        return $this;
    }

    /**
     * Get secondDimension
     *
     * @return float
     */
    public function getSecondDimension()
    {
        return $this->secondDimension;
    }

    /**
     * Set thirdDimension
     *
     * @param float $thirdDimension
     * @return Application
     */
    public function setThirdDimension($thirdDimension)
    {
        $this->thirdDimension = $thirdDimension;

        return $this;
    }

    /**
     * Get thirdDimension
     *
     * @return float
     */
    public function getThirdDimension()
    {
        return $this->thirdDimension;
    }

    /**
     * Set quantity
     *
     * @param float $quantity
     * @return Application
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;

        return $this;
    }

    /**
     * Get quantity
     *
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Set cost
     *
     * @param float $cost
     * @return Application
     */
    public function setCost($cost)
    {
        $this->cost = $cost;

        return $this;
    }

    /**
     * Get cost
     *
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * Set fullName
     *
     * @param string $fullName
     * @return Application
     */
    public function setFullName($fullName)
    {
        $this->fullName = $fullName;

        return $this;
    }

    /**
     * Get fullName
     *
     * @return string
     */
    public function getFullName()
    {
        return $this->fullName;
    }

    /**
     * Set company
     *
     * @param string $company
     * @return Application
     */
    public function setCompany($company)
    {
        $this->company = $company;

        return $this;
    }

    /**
     * Get company
     *
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set phone
     *
     * @param string $phone
     * @return Application
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Application
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return Application
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set loading
     *
     * @param \AppBundle\Entity\Port $loading
     * @return Application
     */
    public function setLoading(\AppBundle\Entity\Port $loading = null)
    {
        $this->loading = $loading;

        return $this;
    }

    /**
     * Get loading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getLoading()
    {
        return $this->loading;
    }

    /**
     * Set unloading
     *
     * @param \AppBundle\Entity\Port $unloading
     * @return Application
     */
    public function setUnloading(\AppBundle\Entity\Port $unloading = null)
    {
        $this->unloading = $unloading;

        return $this;
    }

    /**
     * Get unloading
     *
     * @return \AppBundle\Entity\Port
     */
    public function getUnloading()
    {
        return $this->unloading;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtAsNow()
    {
        $this->createdAt = new \DateTime();
    }
    /**
     * @var \AppBundle\Entity\Connection
     */
    private $connection;


    /**
     * Set connection
     *
     * @param \AppBundle\Entity\Connection $connection
     * @return Application
     */
    public function setConnection(\AppBundle\Entity\Connection $connection = null)
    {
        $this->connection = $connection;

        return $this;
    }

    /**
     * Get connection
     *
     * @return \AppBundle\Entity\Connection
     */
    public function getConnection()
    {
        return $this->connection;
    }
    /**
     * @var \AppBundle\Entity\Voucher
     */
    private $voucher;


    /**
     * Set voucher
     *
     * @param \AppBundle\Entity\Voucher $voucher
     * @return Application
     */
    public function setVoucher(\AppBundle\Entity\Voucher $voucher = null)
    {
        $this->voucher = $voucher;

        return $this;
    }

    /**
     * Get voucher
     *
     * @return \AppBundle\Entity\Voucher
     */
    public function getVoucher()
    {
        return $this->voucher;
    }
    /**
     * @var float
     */
    private $connectionCost;


    /**
     * Set connectionCost
     *
     * @param float $connectionCost
     * @return Application
     */
    public function setConnectionCost($connectionCost)
    {
        $this->connectionCost = $connectionCost;

        return $this;
    }

    /**
     * Get connectionCost
     *
     * @return float
     */
    public function getConnectionCost()
    {
        return $this->connectionCost;
    }
    /**
     * @var float
     */
    private $exchangeRate;


    /**
     * Set exchangeRate
     *
     * @param float $exchangeRate
     * @return Application
     */
    public function setExchangeRate($exchangeRate)
    {
        $this->exchangeRate = $exchangeRate;

        return $this;
    }

    /**
     * Get exchangeRate
     *
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }


    private $exchangeRateeuro;


    /**
     * Set exchangeRate
     *
     * @param float $exchangeRate
     * @return Application
     */
    public function setExchangeRateeuro($exchangeRateeuro)
    {
        $this->exchangeRateeuro = $exchangeRateeuro;

        return $this;
    }

    /**
     * Get exchangeRate
     *
     * @return float
     */
    public function getExchangeRateeuro()
    {
        return $this->exchangeRateeuro;
    }
    /**
     * @var string
     */
    private $quantityType;


    /**
     * Set quantityType
     *
     * @param string $quantityType
     * @return Application
     */
    public function setQuantityType($quantityType)
    {
        $this->quantityType = $quantityType;

        return $this;
    }

    /**
     * Get quantityType
     *
     * @return string
     */
    public function getQuantityType()
    {
        return $this->quantityType;
    }
    /**
     * @var \AppBundle\Entity\User
     */
    private $completedBy;


    /**
     * Set completedBy
     *
     * @param \AppBundle\Entity\User $completedBy
     * @return Application
     */
    public function setCompletedBy(\AppBundle\Entity\User $completedBy = null)
    {
        $this->completedBy = $completedBy;

        return $this;
    }

    /**
     * Get completedBy
     *
     * @return \AppBundle\Entity\User
     */
    public function getCompletedBy()
    {
        return $this->completedBy;
    }
    /**
     * @var \DateTime
     */
    private $completedAt;


    /**
     * Set completedAt
     *
     * @param \DateTime $completedAt
     * @return Application
     */
    public function setCompletedAt($completedAt)
    {
        $this->completedAt = $completedAt;

        return $this;
    }

    /**
     * Get completedAt
     *
     * @return \DateTime
     */
    public function getCompletedAt()
    {
        return $this->completedAt;
    }
    /**
     * @var string
     */
    private $comment;


    /**
     * Set comment
     *
     * @param string $comment
     * @return Application
     */
    public function setComment($comment)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * @var float
     */
    private $warehouse;


    /**
     * Set warehouse
     *
     * @param float $warehouse
     * @return Application
     */
    public function setWarehouse($warehouse)
    {
        $this->warehouse = $warehouse;

        return $this;
    }

    /**
     * Get warehouse
     *
     * @return float
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
}
