<?php

namespace AppBundle\Controller;

use AppBundle\Command\XMLRatesFileDownloadCommand;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\HttpFoundation\Response;

class XMLRatesController extends Controller
{
    /**
     * @return Response
     * @throws \Exception
     */
    public function indexAction()
    {
        if (!in_array(@$_SERVER['REMOTE_ADDR'], array(
            '127.0.0.1',
            '::1',
        ))) {
            return new Response('This script is only accessible from localhost.');
        }

        $command = new XMLRatesFileDownloadCommand();
        $command->setContainer($this->container);
        $input = new ArrayInput(array());
        $output = new NullOutput();
        $command->run($input, $output);

        return new Response('');
    }
}
