<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Entity\SettingEuro;
use AppBundle\Entity\SettingEuroHistory;
use AppBundle\Form\Type\SettingEuroType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class SettingEuroController extends Controller
{
    /**
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function listAction(Request $request)
    {
        $em = $this->getDoctrine();
        $query = $em->getRepository('AppBundle:SettingEuro')->getListQuery();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $query,
            $request->query->get('page', 1),
            20
        );

        return array(
            'pagination' => $pagination
        );
    }

    /**
     * @param Request $request
     * @param Setting $setting
     * @return array
     */
    public function editAction(Request $request, SettingEuro $setting)
    {
        $settingClone = clone($setting);
        $form = $this->createForm(new SettingEuroType(), $setting);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->flush();

            $this->saveSettingEditHistory($settingClone, $setting);

            $this->container->get('app.service.json')->generateJson();

            return $this->redirect($this->generateUrl('app_admin.settingeuro.list'));
        }

        return $this->render(
            'AppBundle:Admin/SettingEuro:form.html.twig',
            array(
                'setting' => $setting,
                'form' => $form->createView()
            )
        );
    }

    /**
     * @Template()
     *
     * @param Request $request
     * @param Setting $setting
     * @return array
     */
    public function historyAction(Request $request, SettingEuro $setting)
    {
        $em = $this->getDoctrine();
        $query = $em->getRepository('AppBundle:SettingEuroHistory')->getHistoryListQuery($setting);

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $query,
            $request->query->get('page', 1),
            20,
            array('defaultSortFieldName' => 'sh.createdAt', 'defaultSortDirection' => 'desc')
        );

        return array(
            'pagination' => $pagination
        );
    }

    /**
     * @param Setting $oldSetting
     * @param Setting $setting
     */
    private function saveSettingEditHistory(SettingEuro $oldSetting, SettingEuro $setting)
    {
        $isEdited = false;
        $settingHistory = new SettingEuroHistory();

        if($oldSetting->getValue() != $setting->getValue()) {
            $settingHistory->setValue($setting->getValue());
            $isEdited = true;
        }

        if($isEdited) {
            $em = $this->getDoctrine()->getManager();
            $settingHistory
                ->setUser($this->getUser())
                ->setSetting($setting);

            $em->persist($settingHistory);
            $em->flush();

            $this->container->get('app.service.json')->generateJson();
        }
    }
}
