<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Entity\Setting;
use AppBundle\Entity\SettingHistory;
use AppBundle\Form\Type\SettingType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class SettingController extends Controller
{
    /**
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function listAction(Request $request)
    {
        $em = $this->getDoctrine();
        $query = $em->getRepository('AppBundle:Setting')->getListQuery();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $query,
            $request->query->get('page', 1),
            20
        );

        return array(
            'pagination' => $pagination
        );
    }

    /**
     * @param Request $request
     * @param Setting $setting
     * @return array
     */
    public function editAction(Request $request, Setting $setting)
    {
        $settingClone = clone($setting);
        $form = $this->createForm(new SettingType(), $setting);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->flush();

            $this->saveSettingEditHistory($settingClone, $setting);

            $this->container->get('app.service.json')->generateJson();
            
            return $this->redirect($this->generateUrl('app_admin.setting.list'));
        }

        return $this->render(
            'AppBundle:Admin/Setting:form.html.twig',
            array(
                'setting' => $setting,
                'form' => $form->createView()
            )
        );
    }

    /**
     * @Template()
     *
     * @param Request $request
     * @param Setting $setting
     * @return array
     */
    public function historyAction(Request $request, Setting $setting)
    {
        $em = $this->getDoctrine();
        $query = $em->getRepository('AppBundle:SettingHistory')->getHistoryListQuery($setting);

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $query,
            $request->query->get('page', 1),
            20,
            array('defaultSortFieldName' => 'sh.createdAt', 'defaultSortDirection' => 'desc')
        );

        return array(
            'pagination' => $pagination
        );
    }

    /**
     * @param Setting $oldSetting
     * @param Setting $setting
     */
    private function saveSettingEditHistory(Setting $oldSetting, Setting $setting)
    {
        $isEdited = false;
        $settingHistory = new SettingHistory();

        if($oldSetting->getValue() != $setting->getValue()) {
            $settingHistory->setValue($setting->getValue());
            $isEdited = true;
        }

        if($isEdited) {
            $em = $this->getDoctrine()->getManager();
            $settingHistory
                ->setUser($this->getUser())
                ->setSetting($setting);

            $em->persist($settingHistory);
            $em->flush();
            
            $this->container->get('app.service.json')->generateJson();
        }
    }
}
